#!/bin/sh
#
# Copyright (c) 2004-2006 by Userful Corporation 
#
# Name: usbinput-reconfig.sh
# Author: Jason Kim
# Description:
# start reconfiguration for the input devices.
############################################
logfile="/var/log/usbinput.log"
NUMOFSTATIONS=
CURRENTDM=
CURRENTXTYPE=

if [ -f /opt/userful/bin/xkeepalive ]; then
    KEEPALIVE="/opt/userful/bin/xkeepalive"
elif [ -f /opt/userful/bin/keepalive ]; then
    KEEPALIVE="/opt/userful/bin/keepalive"
fi

# check User
if [ $UID != 0 ]; then
    echo ""
    echo "   You must be root to configure devices."
    echo ""
    exit 1
fi

if [ ! -d /var/log/userful ]; then
	mkdir /var/log/userful
fi

# Availble video heads
ALL_HEAD=`cat /etc/X11/stations`
# Station number
S_NUM=`cat /etc/stations`
if [ $S_NUM -ge $ALL_HEAD ]; then
	NUMOFSTATIONS=$ALL_HEAD
else
	NUMOFSTATIONS=$S_NUM
fi

# reset the usbinput
#rm -f /etc/usbhub
: > /etc/usbinput.tmp
if [ -e /etc/usbinput ]; then
	while read USBINPUT; do

		if [ ${USBINPUT:1:1} -eq 1 ]; then  # If the current device is configured
	   		USBINPUT=${USBINPUT/1/0}   # replace 1 to 0  (first match)
		fi
    	echo $USBINPUT >> /etc/usbinput.tmp
	done < /etc/usbinput

	# update /etc/usbinput
	rm -f /etc/usbinput
	cp -f /etc/usbinput.tmp /etc/usbinput

	# update /etc/X11/Xinput/configstat
	/opt/userful/bin/make-config-file -r
else
	/opt/userful/bin/make-config-file -r
fi

echo "" >> $logfile
echo "(II) Device reassignment" >> $logfile

#/usr/bin/killall -s USR1 userful-usbinput-config

# Check current Display Manager
if [ -e /etc/userful/currentdm ]; then
	source /etc/userful/currentdm
	if [ -z "$CURRENTDM" ]; then
		CURRENTDM=gdm
	fi
fi

if [ "$CURRENTDM" == "kdm" -o "$CURRENTDM" == "xdm" ]; then
    for ((i = 0; i < $NUMOFSTATIONS; i++))
    do
		# find out xdm's greeter is running in each station.
		# If then, kill login-server to start usb-config wrapper..
		/opt/userful/bin/checkGrabKeyboard -display :$i
		IsRunning=$?

		if [ "$IsRunning" = 1 ]; then
			if [ -e /var/run/pid.login-server$i ]; then
	    		kill `cat /var/run/pid.login-server$i`    
			fi
		fi	
    done
    sleep 1;
else
	# Start userful-usbinput-config program in each station 
	for ((i = 0; i < $NUMOFSTATIONS; i++))
	do
    	if [ -e /var/run/pid.kbdlink$i ]; then
			if [ -e /proc/`cat /var/run/pid.kbdlink$i` ]; then
	    		#echo userful-usbinput-config exist already..
				:
			else
	    		/opt/userful/bin/userful-usbinput-config -display :$i -r > /var/log/userful/usbinput-config.log 2>&1 &
			fi
    	else  
	   		/opt/userful/bin/userful-usbinput-config -display :$i -r > /var/log/userful/usbinput-config.log 2>&1 &
    	fi
	done
fi

sleep 1
/usr/bin/killall -s USR1 userful-usbinput-config
#/opt/userful/bin/send_signal
#sleep 1
#sleep 2

# re-initialize USBConfigDaemon
if pgrep USBConfigDaemon > /dev/null 2>&1; then
    #pkill USBConfigDaemon
	:
else
	if [ -z "$CURRENTDM" ]; then
    	$KEEPALIVE /opt/userful/bin/USBConfigDaemon &
	else
    	$KEEPALIVE /opt/userful/bin/USBConfigDaemon -dm $CURRENTDM &
	fi
fi

# re-initialize kbd-daemon
if pgrep kbd-daemon > /dev/null 2>&1; then
	pkill kbd-daemon
else
	$KEEPALIVE 	/opt/userful/bin/kbd-daemon 2>>/var/log/kbd-daemon.log &
fi

# re-initialize mse-daemon
if pgrep mse-daemon > /dev/null 2>&1; then
	pkill mse-daemon
else
	$KEEPALIVE /opt/userful/bin/mse-daemon 2>>/var/log/mse-daemon.log &
fi

sleep 1
/usr/bin/killall -s HUP userful-usbinput-config
rm -f /etc/usbinput.tmp
