#!/bin/bash
#
# Copyright (c) 2005-2006 by Userful Corporation
#
# Name: userful-input-remove.sh
# Author: Jason Kim <jason@userful.com>
# Description:
#    This script is called from udev rule in 99-userful-hotplug.rules. It starts GUI for
#	kbd-assignment if a keyboard device has been removed. 
#
# $1: kernel name of the device (event#)
##################################################################################

logfile="/var/log/usbinput.log"

#echo "#######################" >> $logfile
#echo "run userful-input-remove.sh" >> $logfile
#echo "########################" >> $logfile

DEV_NAME=
DEV_NUM=
DEV_STR=

UNPLUG_DEVICE=
PROTOCOL=
SCREENNUM=

TRUE=1
FALSE=0

# start GUI for kbd-assignment. unconfigure devices that have same screenNum.
function unplug_kbd()
{
	rm -f /tmp/unplug.tmp
	while read USBINPUT; do
		# find usbinput entries having same screen number
    	if echo "$USBINPUT" | grep "Srn#=$SCREENNUM" > /dev/null; then
			if [ ${USBINPUT:1:1} -eq 1 ]; then  # If the current device is configured
	    		USBINPUT=${USBINPUT/1/0}   # replace 1 to 0  (first match)
			fi
    	fi
    	echo "$USBINPUT" >> /tmp/unplug.tmp
	done < /etc/usbinput
	cp -f /tmp/unplug.tmp /etc/usbinput

	# update configstat
	/opt/userful/bin/make-config-file -u

	# find current display manager
	if [ -f /etc/userful/currentdm ]; then
    	source /etc/userful/currentdm
	else
		CURRENTDM=gdm
	fi

	# check if GUI for kbd-assignment exists on the $SCREENNUM display
	if [ ! -e /var/run/pid.kbdlink$((SCREENNUM)) -o \
		 ! -d /proc/`cat /var/run/pid.kbdlink$((SCREENNUM))` ]; then
		#echo "userful-input-remove.sh  start GUI.." >> $logfile

		if [ "$CURRENTDM" == "kdm" -o "$CURRENTDM" == "xdm" ]; then
			/opt/userful/bin/checkGrabKeyboard -display :$((SCREENNUM))
			RET=$?

			if [ $RET -eq $TRUE ]; then
				#echo "unplug-inputdev.sh  kill login-server" >> $logfile
				kill `cat /var/run/pid.login-server$((SCREENNUM))`
			else
				#echo "unplug-inputdev.sh  start GUI" >> $logfile
				/opt/userful/bin/userful-usbinput-config -display :$((SCREENNUM)) -r &
			fi
		else
			#echo "unplug-inputdev.sh  start GUI" >> $logfile
			/opt/userful/bin/userful-usbinput-config -display :$((SCREENNUM)) -r &
		fi
		usleep 500000
	else
		#echo "userful-input-remove.sh  GUI is exist already.." >> $logfile
		:
	fi
}

usage()
{
    echo
    echo "Usage: $0 <device name>"
    echo
    exit 1
}

#
# start here...
#
# $1: device name (event#)

# receive only one argument - device name
if [ $# -ne 1 ]; then
    usage
fi

# check current X type
if [ -f /etc/sysconfig/xtype ]; then
	source /etc/sysconfig/xtype

	if [ "$XTYPE" = SINGLE -o "$XTYPE" = single ]; then
		exit 1
	fi
fi

DEV_NAME=$1 # event device
DEV_NUM=${DEV_NAME#event}  # event device number

# get the DEV#=XXX string for the usbinput file
if [ $DEV_NUM -lt 10 ]; then
	DEV_STR="Dev#=00$DEV_NUM"
elif [ $DEV_NUM -lt 100 ]; then
	DEV_STR="Dev#=0$DEV_NUM"
else
	DEV_STR="Dev#=$DEV_NUM"
fi

date >> $logfile
echo "remove device) $DEV_NAME" >> $logfile
#echo "DEV_STR = $DEV_STR" >> $logfile

UNPLUG_DEVICE=`grep "$DEV_STR" /etc/usbinput`
if [ -z $UNPLUG_DEVICE ];then
    exit 1 # no entry in the usbinput file. may not a real input device
fi

SCREENNUM=${UNPLUG_DEVICE:32:2}
PROTOCOL=${UNPLUG_DEVICE:40:2}

case "$PROTOCOL" in
	"01" ) # keyboard
		unplug_kbd
		;;
	"02"|"03"|"04" ) # Mouse, Card reader and Magnetic swipe
		/opt/userful/bin/make-config-file -u
		;;
	"05" ) # Touch Screen
		/opt/userful/bin/make-config-file -u
		/opt/userful/bin/send_signal
		;;
esac

# Removing many keyboards at the same time causes GUI crash
#killall -HUP userful-usbinput-config
pkill kbd-daemon
pkill mse-daemon
