#!/bin/bash
#
# calibrate.sh
#
# 	Calibrate TouchScreen device.
#
#   Jason Kim <jason@userful.com>

PATH=$PATH:/usr/X11R6/bin/

XINIT=`which xinit`
XSERVER="/opt/MX11R6/bin/Xorg"
MXCONF="userful.Mxorg.conf"
XCLIENT="/opt/userful/evtouch/check-touch-config"
MINX=
MINY=
MAXX=
MAXY=

if [ -f /opt/userful/bin/xkeepalive ]; then
	KEEPALIVE="/opt/userful/bin/xkeepalive"
elif [ -f /opt/userful/bin/keepalive ]; then
	KEEPALIVE="/opt/userful/bin/keepalive"
fi

#
# update userful.Mxorg.conf based on out.txt and test new configuration
#
function test_calibration_config()
{
	# comment out Option "Calibrate" "1" from the userful.Mxorg.conf
	if grep "^[[:space:]]*Option[[:space:]]*\"Calibrate\"" /etc/X11/userful.Mxorg.conf > /dev/null 2>&1; then
        echo "commnent out Calibrate"
        sed -i -e "s/^[[:space:]]*Option[[:space:]]*\"Calibrate\".*/\t#Option \"Calibrate\" \"1\"/g" \
				/etc/X11/userful.Mxorg.conf
	fi

	# update MinX, MinY, MaxX and MaxY based on out.txt
    # MinX
    TMP=`grep "MinX" /opt/userful/evtouch/out.txt`
    MINX=`echo $TMP`
    if [ ! -z "$MINX" ]; then
        echo "update MinX"
        sed -i -e "s/^[[:space:]]*Option[[:space:]]*\"MinX\".*/\t$MINX/g" /etc/X11/userful.Mxorg.conf
    fi

    # MinY
    TMP=`grep "MinY" /opt/userful/evtouch/out.txt`
    MINY=`echo $TMP`
    if [ ! -z "$MINY" ]; then
        echo "update MinY"
        sed -i -e "s/^[[:space:]]*Option[[:space:]]*\"MinY\".*/\t$MINY/g" /etc/X11/userful.Mxorg.conf
    fi

    # MaxX
    TMP=`grep "MaxX" /opt/userful/evtouch/out.txt`
    MAXX=`echo $TMP`
    if [ ! -z "$MAXX" ]; then
        echo "update MaxX"
        sed -i -e "s/^[[:space:]]*Option[[:space:]]*\"MaxX\".*/\t$MAXX/g" /etc/X11/userful.Mxorg.conf
    fi

    # MaxY
    TMP=`grep "MaxY" /opt/userful/evtouch/out.txt`
    MAXY=`echo $TMP`
    if [ ! -z "$MAXY" ]; then
        echo "update MaxY"
        sed -i -e "s/^[[:space:]]*Option[[:space:]]*\"MaxY\".*/\t$MAXY/g" /etc/X11/userful.Mxorg.conf
    fi

	# start test program for the current TouchScreen configuration
	$XINIT $XCLIENT  -- $XSERVER :0 -br -xf86config $MXCONF

}

#
# Initialization
#
function initialize_calibration()
{
	if [ -z "$XINIT" ]; then
    	echo "xinit not found. exiting ..."
    	exit 1
	fi

	# "check-touch-config" will create /tmp/calibration file if calibration is finished
	rm -f /tmp/calibration
	rm -f /opt/userful/evtouch/out.txt
	rm -f /etc/usbinput
}

#
# assign touchscreen pointer to first touchscreen display
#
function assign_touchscreen_pointer()
{
	# create soft link for input devices before start MX
	/opt/userful/bin/make-config-file  

	if [ -f /root/xorg.conf.new ]; then
		/opt/userful/bin/dm-gen-xconfig.sh -1box
	else
		/opt/userful/bin/mx-config-gen.sh -1box
	fi
	sleep 1

	#start Daemons for configuration
	
	$KEEPALIVE /opt/userful/bin/USBConfigDaemon &
	$KEEPALIVE /opt/userful/bin/kbd-daemon 2>/var/log/kbd-daemon.log &
	$KEEPALIVE /opt/userful/bin/mse-daemon 2>/var/log/mse-daemon.log &
	$KEEPALIVE /opt/userful/bin/MXSigDaemon 2>/var/log/MXSigDaemon.log &
	sleep 1

	# comment out Option "Calibrate" "1" from the userful.Mxorg.conf
	if grep "^[[:space:]]*Option[[:space:]]*\"Calibrate\"" /etc/X11/userful.Mxorg.conf > /dev/null 2>&1; then
    	echo "commnent out Calibrate"
    	sed -i -e "s/^[[:space:]]*Option[[:space:]]*\"Calibrate\".*/\t#Option \"Calibrate\" \"1\"/g" \
				/etc/X11/userful.Mxorg.conf
	fi

	# start kbd-assignment program to assign touchscreen pointer to first touchscreen
	$XINIT /opt/userful/bin/userful-usbinput-config -display :0 -- $XSERVER :0 -br -xf86config $MXCONF
}

function finalize_calibration()
{
	#pkill USBConfigDaemon
	pkill kbd-daemon
	pkill mse-daemon
	pkill MXSigDaemon
}
##################
# start here...
##################

# initialization
initialize_calibration

# assign touchscreen pointer to first touchscreen
assign_touchscreen_pointer

#
# iterate calibration procedure until it gets correct configuration.
#
while [ ! -e /tmp/calibration ]
do
	sleep 1
	if [ -e /tmp/ev_calibrate ]; then
		rm -f /tmp/ev_calibrate  # delete existing FIFO
	fi

	echo "Creating FIFO..."
	mknod /tmp/ev_calibrate p

	echo "Starting calibration program..."
	# need to set Option "Calibrate" "1" for calibration program
	if grep "[[:space:]]*#[[:space:]]*Option[[:space:]]*\"Calibrate\"" /etc/X11/userful.Mxorg.conf \
		> /dev/null 2>&1; then
    	#echo "set Calibrate"
    	sed -i -e "s/^[[:space:]]*#[[:space:]]*Option[[:space:]]*\"Calibrate\"[[:space:]]*\"1\"/\tOption \"Calibrate\" \"1\"/g" \
				/etc/X11/userful.Mxorg.conf
	fi

	# start calibration program
	$XINIT /opt/userful/evtouch/ev_calibrate -- $XSERVER :0 -br -xf86config $MXCONF
	sleep 1

	if [ -e /opt/userful/evtouch/out.txt ]; then
		test_calibration_config  # test current TouchScreen configuration
		rm -f /opt/userful/evtouch/out.txt
	fi
done

# finalize
#finalize_calibration

exit 0
