#!/bin/bash
#
# multistation-devices-config.sh
#
#
#    Copyright (c) 2002-2007 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
# Description
# 	- call multistation-audio-config.sh and multistation-storage-config.sh when system
# 	  starts
#
# Called from: prefdm_multi
#
# Call: multistation-audio-config.sh, multistation-storage-config.sh

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

if [ ! -f /etc/sysconfig/xtype ]; then
	echo "`date +"%b %d %T"` $ProgramName: Unable to find /etc/sysconfig/xtype" >> $logfile
	exit 1
fi

# Call device refresh script for DST4
if [ -x /opt/userful/bin/usbaudio-refresh.sh ]; then
    /opt/userful/bin/usbaudio-refresh.sh
fi

#
# Audio Device
#
if [ -f /opt/userful/bin/multistation-audio-config.sh ]; then
	/opt/userful/bin/multistation-audio-config.sh
else
	echo "`date +"%b %d %T"` $ProgramName: The Audio Support program is not found. The package for Audio Support may not be installed yet." >> $logfile
fi

#
# Storage Device
#
if [ -f /opt/userful/bin/multistation-storage-config.sh ]; then
	/opt/userful/bin/multistation-storage-config.sh
else
	echo "`date +"%b %d %T"` $ProgramName: The Storage Support program is not found. The package for Storage Support may not be installed yet." >> $logfile
fi
