#!/bin/bash
#
# dm-config-hotplug.sh
#
#    Configure hotplug agent based on current X type.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
# Hotplug agent does not exist anymore in the latest Linux distros.
#

# Configure the hotplug agents based on current X type
# $1: CURRENTXTYPE
if [[ "$1" = "single" ]]; then
  	if [[ -e /etc/hotplug.d/usb/50-usb.hotplug.multi ]]; then 
		cp -f /etc/hotplug.d/input_device/50-input_device.hotplug.multi-save \
      	  	  /etc/hotplug.d/input_device/50-input_device.hotplug
		cp -f /etc/hotplug.d/usb/50-usb.hotplug.multi-save \
		  	  /etc/hotplug.d/usb/50-usb.hotplug

  	elif [[ -e /etc/hotplug/usb.agent.multi-save ]]; then 
  		cp -f /etc/hotplug/usb.agent.multi-save /etc/hotplug/usb.agent
  		cp -f /etc/hotplug/input.agent.multi-save /etc/hotplug/input.agent
  	fi

elif [[ "$1" = "multi" ]]; then
  if [[ -e /etc/hotplug.d/usb/50-usb.hotplug.multi ]]; then 
	cp -f /etc/hotplug.d/input_device/50-input_device.hotplug.multi \
      	  /etc/hotplug.d/input_device/50-input_device.hotplug
	cp -f /etc/hotplug.d/usb/50-usb.hotplug.multi \
		  /etc/hotplug.d/usb/50-usb.hotplug

  elif [[ -e /etc/hotplug/usb.agent.multi ]]; then 
  	cp -f /etc/hotplug/usb.agent.multi /etc/hotplug/usb.agent
  	cp -f /etc/hotplug/input.agent.multi /etc/hotplug/input.agent
  fi

fi
