
/*
 * LIB/VENDOR.H
 *
 * This header file is available for you to specify custom parameters to
 * diablo.
 *
 * WARNING!  Diablo does not use make depend, so any changes you make to
 * this or any other header file should be followed by a complete
 * recompile.  e.g. 'xmake clean; xmake'
 */

/*
 * When posting an article, check validity of From: address.
 * Note that this may well disallow slightly unusual addresses 
 * that are quite valid.  It was designed to deal with a spammer
 * who liked to post with a variety of From: names like 
 * "sally@fuck.net".  This version understands things like the
 * .invalid TLD, although sanity checks are still done even on
 * a .invalid address.
 *
 * If you use this, check dreaderd/post-addr-ck.c to see if
 * the rules are valid for your purposes.  Should be easy to
 * modify.
 */

#undef	POST_CKADDRESS

/*
 * When posting an article, scan the submitted article for this
 * path element.  If it exists, reject the article.  This also
 * turns on some other checks to try to prevent people from
 * POST'ing articles that they fetched from Usenet back into you.
 */

/* #define POST_CKPATHLOOP "!news.site.com!" */

#undef	POST_CKPATHLOOP

/*
 * When posting an article, force the rewrite of the Message-ID:.
 * YOU MUST USE POST_CKPATHLOOP WITH THIS OPTION, TO AVOID ENDLESS
 * REPOST LOOPS.  This option is controversial, but allows you to
 * do some neat things like restrict cancel messages to Message-ID's
 * generated by your site.
 */

#undef	POST_FORCEMSGID

/*
 * When posting an article, clean up non- or obsolete Usenet
 * headers.
 */

#undef	POST_BOFHCLEANUP

/*
 * When posting a cancel, verify that the original message came from
 * this system.  Requires POST_FORCEMSGID.  Also prevents Supersedes
 * attacks.
 */

#undef	POST_RESTRICTCANCEL

/*
 * When posting a message, encode the NNTP posting host through a one-
 * way function.  This protects your users from being ping-flooded,
 * etc., but permits the identification of posts coming from the same
 * node within a short period of time.  Highly recommended.
 */

#undef	POST_HIDENNTPPOSTHOST

/*
 * When posting a message, forcibly add an NNTP-Posting-Date:
 * header. There is a separate option to use GMT or localtime.
 * Only use one or neither of the following two options.
 */

#undef	POST_NNTP_POSTING_DATE_GMT
#undef	POST_NNTP_POSTING_DATE_LOCALTIME

/*
 * When posting a message, encrypt the X-Trace line with DES.  Again,
 * highly recommended.
 */

#undef	POST_CRYPTXTRACE

/*
 * Enable RADIUS authentication.  Works on FreeBSD or similar libradius.
 */

#undef	RADIUS_ENABLED

/*
 * Enable CDB authentication. Needs the CDB libraries installed.
 * Available from: http://cr.yp.to/cdb.html
 *
 * You also need to add the following to the LFLAGS line in XMakefile.inc
 *  -L$(BD)cdb -lcdb
 */

#undef	CDB_ENABLED

/*
 * Enable Berkeley DB authentication. Needs the DB libraries installed.
 *
 */

#undef	DB_ENABLED

/*
 * Set a path to a Berkeley DB that includes a list of users that
 * should be rejected before auth methods are consulted
 *
 */

#undef	REJECT_DB	/* "/news/db/reject.db" */

/*
 * Enable NetRemote authentication.  Works on FreeBSD, requires DES.
 */

#undef	NETREMOTE_ENABLED

/*
 * Enable LDAP authentication.  Requires LDAP libraries and -lldap to
 * be add to LFLAGS in XMakefile.inc
 */

#undef	LDAP_ENABLED

/*
 * Enable a new and more flexible form of LDAP authentication.
 * (Requires LDAP_ENABLED)
 *
 * Configuration is done via an LDAP URL of the form:
 *
 * ldap://hostname[:port]/dn?userPassword?scope?filter [username:passwd]
 *
 * where:
 *	userPassword is the attribute that contains the clear text password,
 *	usually called "userPassword".
 *
 *	scope is probably normally "sub" or "base".
 *
 * 	filter consists of the username and password attributes and any
 *	other site specific search options required to narrow a search
 *	to a single user. The following values can be used and will
 *	be replaced by the corresponding value supplied from Diablo.
 *
 *		$USER$		username
 *		$PASS$		password
 *		$REALM$		authentication domain, if realms are used
 *
 *	username:passwd is the username and password with which to
 *	authenticate to the LDAP server. If they are not specified,
 *	anonymous authentication is done.
 *
 * Example:
 *
 * ldap://host.example.com/dc=$REALM$,dn=example.com?userPassword?sub?(userName=$USER$)
 *
 */

#undef	NEW_LDAP

/*
 * Enable PAM authentication. Requires a PAM library and -lpam to be added
 * to LFLAGS in XMakefile.inc. This has been confirmed to work
 * on Linux and appears to work on FreeBSD. The pam_unix.so module
 * is unlikely to work as it requires root access to verify the
 * password.
 */

#undef PAM_ENABLED

/*
 * Enable a local C filter for outbound posts.  This filter allows you to
 * return a char * string, which would be an error to be handed back to the
 * user, or a NULL, which means that the article passes.
 *
 * Supplying a char *PostCFilter(char *base, int artLen, Connection *conn)
 * filter function is left as an exercise for the news admin.
 */

#undef	POST_CFILTERHOOK

/*
 * Experimental compression. This option requires zlib (-lz added
 * to LFLAGS in XMakefile.inc) and if set, enables an option 'compresslvl'
 * in dspool.ctl that allows you to set spool objects as compressed. The
 * number refers to the zlib level, which is lower (min 1) for faster
 * compression and higher (max 9) for slower, but better compression. All
 * article files written to the spool object(s) are compressed, with multiple
 * articles per file as normal. Each article is compressed separately so
 * that spool recovery is possible using diloadfromspool.
 * Example entry in dspool.ctl.
 *	compresslvl	5
 * This option also enables compressed newsfeeds. See the sample dnewsfeeds
 * entry for a description.
 */
#undef	USE_ZLIB

/*
 * Add CPU timing to dreaderd clients. Enabling this option causes an
 * extra timing value to be added to the client closing stats.
 */
#undef DREADER_CLIENT_TIMING

/*
 * Log Supercedes: headers to LOG_DEBUG in whilst feeding
 */
#undef LOG_FEED_SUPERCEDES

/*
 * If a X-Original-NNTP-Posting-Host: header exists in a post, then
 * use this instead of NNTP-Posting-Host: when doing the spamfilter test
 *
 * Note: This is not on by default, because it could be used to circumvent
 * the nph filter.
 */
#undef USE_X_ORIGINAL_NPH

/*
 * Enable the use of banning lists in dreaderd. The banning lists are
 * not really suitable for general use, but are very useful on open
 * news servers that are regularly abused by clients trying to exceed
 * the configured access limits. See diablo.config for details on how
 * to configure the parameters.
 */
#undef	READER_BAN_LISTS

/*
 * Have Diablo report the (approximate) age of retrieved articles.
 * For those sites running with distributed spools, this can help
 * you judge just how big secondary spools need to be in order to
 * be most cost-effective.  Most articles retrieved tend to be
 * recent, and by plugging these age values into a graphing program,
 * it should become readily apparent what the best amount of time
 * would be for storage on a secondary spool.
 */
#undef	STATS_ART_AGE

/*
 * Experimental IPV6 support. This covers newsfeeding (inbound and outbound)
 * and newsreading. It doesn't do some of the more exotic stuff, like
 * ident lookups, reader to spool connections, etc.
 *
 * NOTE: When using the bind options to specify IPv6 addresses, the
 * IPv6 address should be enclosed in '[]' otherwise the last portion
 * of the IPv6 address could be taken for the port. e.g:
 *	-B[::1]:119
 */
#undef INET6

/*
 * Experimental PERL authentication by an external script.  Requires
 * perl-5.6 and -L and -I options added to XMakefile.inc CFLAGS and LFLAGS
 * based on the results of:
 *
 * perl -MExtUtils::Embed -e ccopts
 * perl -MExtUtils::Embed -e ldopts
 *
 * e.g:
 *
 * -I/usr/local/lib/perl5/5.6.1/sun4-solaris/CORE
 * -L/usr/local/lib/perl5/5.6.1/sun4-solaris/CORE -lperl
 *
 * The perl script is specified as an authdef in dreader.access.
 * A sample perl script is available in contrib/ckpasswd  and uses
 * the DBI module to check the user against an external Oracle DB.
 *
 * Basically, the perl script must return:
 *
 *	100 Success		- for successful authentication using the
 *				  readerdef entry matched in dreader.access
 *	110 readerdef		- for success, using the returned readerdef
 *	Any other result	- authentication rejected
 */

#undef	PERL_ENABLED

/*
   Enable a filter which examines Message-ID's offered by check and ihave
   commands
 */
#define USE_OFFER_FILTER 1
