TITLE asmfunc.asm

; This file contains some assembler functions used by LHMAIN.C

DGROUP GROUP _DATA

ASSUME CS:_TEXT, DS:DGROUP

_DATA SEGMENT WORD PUBLIC 'DATA'
   extrn _init:BYTE
   extrn _pspSeg:WORD
   extrn _exitcode:BYTE
   extrn _exittype:BYTE
   extrn _UMBLink:WORD
_DATA ENDS

_TEXT SEGMENT WORD PUBLIC 'CODE'

public _execute, _createChildPSP, _farmemcpy, _farmemcmp

; This equate will point to the stack frame

frame equ [bp+4]

sp_save dw ?
ss_save dw ?

; execute: 
; This routine prepares for execution of the new program,
; transfers control to it, reads the exit code and returns.

_execute PROC 
  push  bp
  push  di
  push  si
  push  ds

; push current PSP, to restore it later
  mov   ah, 62h
  int   21h
  push  bx

; save the current stack
  mov   word ptr cs:sp_save, sp
  mov   word ptr cs:ss_save, ss

; ds:si points at the "init" structure, that holds the initial register values
  mov   si, offset DGROUP:_init
  
; switch to new stack
  cli
  mov   sp, word ptr [si+4]
  mov   ss, word ptr [si+6]
  sti

; set current PSP to the new program's PSP
  mov   ah, 50h
  mov   bx, word ptr DGROUP:_pspSeg
  int   21h
  
  push  ds
; set the DTA to PSP:80h
  mov   ds, word ptr DGROUP:_pspSeg
  mov   dx, 80h
  mov   ah, 1ah
  int   21h

  pop   ds
  mov   si, offset DGROUP:_init   
  
; load registers with initial values
  mov   ax, word ptr [si+8]
  mov   bx, word ptr [si+0ah]
  mov   cx, word ptr [si+0ch]
  mov   dx, word ptr [si+0eh]

  mov   es, word ptr [si+12h]
  push  word ptr [si+2]         ; init.cs
  push  word ptr [si]           ; init.ip
  mov   ds, word ptr [si+10h]
  
; jump to program's starting adress
  retf

term_address:
; We're back. Switch to the old stack.
  cli
  mov   sp, word ptr cs:sp_save
  mov   ss, word ptr cs:ss_save
  sti

; set current PSP to our PSP
  pop   bx
  mov   ah, 50h
  int   21h

; get the program's exit code
  mov   ah, 4dh
  int   21h
  pop   ds
  mov   byte ptr DGROUP:_exitcode, al
  mov   byte ptr DGROUP:_exittype, ah
 
; return success
  xor   ax, ax
  pop   si
  pop   di
  pop   bp
  retn
_execute ENDP

; farmemcpy
; it won't handle overlapping blocks correctly

_farmemcpy PROC
  push  bp
  mov   bp, sp
  push  di
  push  si
  push  ds

  mov   cx, frame+8
  jcxz  done

  lds   si, frame+4
  les   di, frame
  rep   movsb
   
done:
  pop   ds
  pop   si
  pop   di
  pop   bp
  retn
_farmemcpy ENDP

; farmemcmp: Compares two memory regions, returns zero if
; they're equal, non-zero if they're not

_farmemcmp PROC
  push  bp
  mov   bp, sp
  push  di
  push  si
  push  ds

  xor   ax, ax
  mov   cx, frame+8
  jcxz  get_out_of_here

  lds   si, frame+4
  les   di, frame
  repe  cmpsb   
  je    get_out_of_here
  mov   al, 0ffh

get_out_of_here:
  pop   ds
  pop   si
  pop   di
  pop   bp
  retn
_farmemcmp ENDP

; createChildPSP:

_createChildPSP PROC 
  push bp
  mov  bp, sp
  push si
  push di
  push ds

; save the current PSP
  mov  ah, 62h
  int  21h
  push bx

; Set interrupt vector 22h, to get the desired termination address
; written into the new PSP.
  push cs
  pop  ds
  mov  dx, offset term_address
  mov  ax, 2522h
  int  21h

; now, create the new PSP
  mov  ah, 55h
  mov  dx, word ptr frame    ; segment address of new PSP
  mov  si, word ptr frame+2  ; value in 'memory size' field
  int  21h

; Restore current PSP
  pop  bx
  mov  ah, 50h
  int  21h
  xor  ax, ax

  pop  ds
  pop  di
  pop  si
  pop  bp
  retn
_createChildPSP ENDP

magic_pattern db "#e$n%t&r/Y("

ASSUME DS:_TEXT

Entry PROC
; This function is called by the loader program.
;
; It's purpose is to set up registers and stuff like the C startup code 
; expects, before jumping to the "actual" starting point of the program
  
; set PSP
  mov  bx, cs
  mov  ah, 50h
  int  21h

; switch stack
; since it's a COM program, all segment registers will have 
; the same value

  mov  ax, cs
  mov  ds, ax
  mov  es, ax

  cli
  mov  ss, ax
  mov  sp, 0fffeh
  sti

; jump to the actual entry point - CS:100h
  mov  ax, 100h
  jmp  ax
Entry ENDP

_TEXT ENDS
END
