/*
   DISKCOPY.EXE, floppy diskette duplicator similar to MSDOS Diskcopy.
   Copyright (C) 1998, Matthew Stanford.
   Copyright (C) 1999, 2000, 2001 Imre Leber.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have recieved a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


   If you have any questions, comments, suggestions, or fixes please
   email me at: imre.leber@worldonline.be

 */

#ifndef BOOT_H_
#define BOOT_H_

/* The boot sector struct */
struct BootSectorStruct
  {
    char Jump[3];			/* Jump instruction in boot routine. */
    char Identification[8];		/* Identification code.              */
    unsigned short BytesPerSector;	/* bytes per sector.                 */
    unsigned char SectorsPerCluster;	/* sectors per cluster.              */
    unsigned short ReservedSectors;	/* number of reserved sectors.       */
    unsigned char Fats;			/* number of fats.                   */
    unsigned short NumberOfFiles;	/* number of files or directories in */
					/* the root directory.               */
    unsigned short NumberOfSectors;	/* number of sectors in the volume.  */
    unsigned char descriptor;     	/* media descriptor.                 */
    unsigned short SectorsPerFat;	/* number of sectors per fat.        */
    unsigned short SectorsPerTrack;	/* sectors per track.                */
    unsigned short Heads;       	/* number of read/write heads.       */
    unsigned short Divider;
    char Filler[9];                     /* Skip to serial number.               */
    unsigned char SerialNumber[4];      /* Disk serial number starting at 0x27. */
    char BootRoutine[482];      	/* bootroutine.                      */
  };

/* A few simple defines */
#define BYTESPERSECTOR    512
#define ENTRIESPERSECTOR  (BYTESPERSECTOR / 32)

/* This is not used in diskcopy, intended for defrag 
   int ReadBootSector(RDWRHandle handle, struct BootSectorStruct* buffer);
   int WriteBootSector(RDWRHandle handle, struct BootSectorStruct* buffer);

   unsigned char  GetSectorsPerCluster(RDWRHandle handle);
   unsigned short GetReservedSectors(RDWRHandle handle);
   unsigned char  GetNumberOfFats(RDWRHandle handle);
   unsigned short GetNumberOfRootEntries(RDWRHandle handle);
   unsigned char  GetMediaDescriptor(RDWRHandle handle);
   unsigned short GetNumberOfSectors(RDWRHandle handle);
   unsigned short GetSectorsPerFat(RDWRHandle handle);
   unsigned short GetSectorsPerTrack(RDWRHandle handle);
   unsigned short GetReadWriteHeads(RDWRHandle handle);
   unsigned short GetClustersInDataArea(RDWRHandle handle);
 */

#endif
