/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_RDS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	Cfg_FctGetopt cfg_rdString

	read will return the characters until '\0' is reached. Then
	permanently EOF.

ob(ject): cfg_rdString
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Read from a static string
he(ader files): 
lo(ng description): Return the next character of a static string.
pr(erequistes): 
va(lue): EOF: end of string\item else: character
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_rds.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_RDS.C 1.5 2001/02/27 01:28:08 ska Exp ska $";
#endif

int cfg_rdString(struct Cfg_Getopt *optstru)
{	unsigned char *p;
	int ch;

	DBG_ENTER("cfg_rdString", Suppl_cmdline)

	assert(optstru);
	assert(C(_stk));

	if((p = S(getArg)) != 0 && (ch = *p) != 0) {
		S(getArg) = p + 1;
		DBG_RETURN_C( ch)
	}

	DBG_RETURN_C( EOF)
}
