/////////////////////////////////////////////////////////////////////////////
// Name:        NewPropjectDlg.cpp
// Purpose:     New project dialog
// Author:      Alex Thuering
// Created:	29.10.2006
// RCS-ID:      $Id: NewProjectDlg.cpp,v 1.12 2008/12/30 20:49:30 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "NewProjectDlg.h"
#include "DVD.h"
#include "Config.h"

NewProjectDlg::NewProjectDlg(wxWindow *parent) :
	wxPropDlg(parent) {
	Create();
	SetTitle(_("Create a new DVD"));
	SetSize(400, -1);
}

void NewProjectDlg::CreatePropPanel(wxSizer* sizer) {
	wxFlexGridSizer* grid = new wxFlexGridSizer(2, 1, 16);
	grid->AddGrowableCol(1);
	sizer->Add(grid, 0, wxEXPAND|wxALL, 6);
	AddTextProp(grid, _("Disc label:"), s_config.GetDefDiscLabel());
	wxArrayString labels = DVD::GetCapacityLabels();
	AddChoiceProp(grid, _("Disc capacity:"), labels[s_config.GetDefDiscCapacity()], labels);

	// Video bitrate
	labels = DVD::GetVideoBitrateLabels();
	int b = s_config.GetVideoBitrate();
	int q = b == -1 ? 0 : (b%1000 == 0 && b>=2000 && b<=8000 ? 9-b/1000 : 8);
	wxSizer* vbSizer = AddChoiceCustomProp(grid, _("Video quality:"), labels[q], labels, 8, 100, false);
	vbSizer->AddSpacer(4);
	AddSpinProp(vbSizer, wxT(""), b == -1 ? 4500 : b, 500, 9000, 80, _("KBit/s"), false);
	SetLastControlCustom(GetLastControlIndex()-1, q == 10);

	// Video and audio format
	wxFlexGridSizer* fSizer = new wxFlexGridSizer(3, 1, 16);
	fSizer->AddGrowableCol(0);
	fSizer->AddGrowableCol(1);
	fSizer->AddGrowableCol(2);
	sizer->Add(fSizer, 0, wxEXPAND|wxALL, 6);
	// Video formT
	wxSizer* grp = BeginGroup(fSizer, _("Video Format"));
	grp->AddSpacer(4);
	wxArrayString formats = DVD::GetVideoFormatLabels();
	AddRadioGroupProp(grp, formats, s_config.GetDefVideoFormat() - 2);
	grp->AddSpacer(4);
	// Aspect Ratio
	formats = DVD::GetAspectRatioLabels();
	grp = BeginGroup(fSizer, _("Aspect Ratio"));
	grp->AddSpacer(4);
	AddRadioGroupProp(grp, formats, s_config.GetDefAspectRatio() - 1);
	grp->AddSpacer(4);
	// Audio format
	grp = BeginGroup(fSizer, _("Audio Format"));
	grp->AddSpacer(4);
	formats = DVD::GetAudioFormatLabels();
	AddRadioGroupProp(grp, formats, s_config.GetDefAudioFormat() - 2);
	grp->AddSpacer(4);
}

wxString NewProjectDlg::GetLabel() {
	return GetString(0);
}

DiscCapacity NewProjectDlg::GetCapacity() {
	return (DiscCapacity) GetInt(1);
}

int NewProjectDlg::GetVideoBitrate() {
	int q = GetInt(2);
	int b = GetInt(3);
	if (q == 0)
		return -1;
	return q < 8 ? (9-q)*1000 : b;
}

VideoFormat NewProjectDlg::GetVideoFormat() {
	return (VideoFormat) (GetInt(4) + 2);
}

AspectRatio NewProjectDlg::GetAspectRatio() {
	return (AspectRatio) (GetInt(5) + 1);
}

AudioFormat NewProjectDlg::GetAudioFormat() {
	return (AudioFormat) (GetInt(6) + 2);
}
