/////////////////////////////////////////////////////////////////////////////
// Name:        Slideshow.h
// Purpose:     The class to store information for slideshow
// Author:      Alex Thuering
// Created:	26.06.2005
// RCS-ID:      $Id: Slideshow.h,v 1.5 2008/12/24 06:04:39 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef SLIDESHOW_H
#define SLIDESHOW_H

#include "Menu.h"

class Slide
{
  public:
    Slide() {}
    Slide(const wxString& filename): m_filename(filename) {}
    Slide(wxSvgXmlNode* node) { PutXML(node); }
    
    inline wxString GetFilename() { return m_filename; }
    inline void SetFilename(const wxString& filename) { m_filename = filename; }
    
    wxSvgXmlNode* GetXML();
	bool PutXML(wxSvgXmlNode* node);
  
  protected:
    wxString m_filename;
};

WX_DEFINE_ARRAY(Slide*, SlideArray);

class Slideshow: public SlideArray
{
  public:
    Slideshow(VideoFormat videoFormat = vfPAL, AspectRatio aspectRatio = ar4_3);
    Slideshow(wxSvgXmlNode* node);
    ~Slideshow();
    
    inline VideoFormat GetVideoFormat() { return m_videoFormat; }
	inline void SetVideoFormat(VideoFormat format) { m_videoFormat = format; }
	wxSize GetResolution();
	inline AspectRatio GetAspectRatio() { return m_aspectRatio; }
	inline void SetAspectRatio(AspectRatio aspectRatio) { m_aspectRatio = aspectRatio; }
    float GetFPS();
    
    inline int GetDuration() { return m_duration; }
    inline void SetDuration(int duration) { m_duration = duration; }
    
    wxImage GetThumbImage(int width, int height);
    wxImage GetImage(int index);
    
    wxSvgXmlNode* GetXML(DVDFileType type, wxSvgXmlNode* node = NULL);
	bool PutXML(wxSvgXmlNode* node);
  
  protected:
    VideoFormat m_videoFormat;
    AspectRatio m_aspectRatio;
    int m_duration;
};

#endif //SLIDESHOW_H
