/////////////////////////////////////////////////////////////////////////////
// Name:        AVPropDlg.cpp
// Purpose:     DVD audio/video properties dialog
// Author:      Alex Thuering
// Created:     23.02.2005
// RCS-ID:      $Id: AVPropDlg.cpp,v 1.11 2010/08/15 18:22:04 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "AVPropDlg.h"

AVPropDlg::AVPropDlg(wxWindow *parent, Video* video, bool menu): wxPropDlg(parent) {
	m_video = video;
	m_menu = menu;
	m_auto = _("auto");
	Create();
	SetSize(360, -1);
}

void AVPropDlg::CreatePropPanel(wxSizer* sizer) {
	wxSizer* grpSizer = BeginGroup(sizer, _("Video"));
	wxFlexGridSizer* grid = new wxFlexGridSizer(2, 2, 4, 16);
	grid->AddGrowableCol(1);
	if (!m_menu) {
		AddChoiceProp(grid, _("Format:"), String2Auto(m_video->GetFormat()), m_video->GetFormatStrings(m_auto));
		AddTextProp(grid, _("Resolution:"), m_video->GetResolution());
		AddChoiceProp(grid, _("Aspect ratio:"), m_video->GetAspectStrings(m_auto)[m_video->GetAspect()],
				m_video->GetAspectStrings(m_auto));
	}
	AddTextProp(grid, _("Caption:"), m_video->GetCaption());
	AddChoiceProp(grid, _("Widescreen:"), m_video->GetWidescreenStrings(m_auto)[m_video->GetWidescreen()],
			m_video->GetWidescreenStrings(m_auto));
	grpSizer->Add(grid, 0, wxEXPAND | wxALL, 6);

	sizer->Add(6, 6);

	if (m_menu)
		AddText(sizer, _("Note: these properties will be set for all menus\nin the current titleset"));
	else
		AddText(sizer, _("Note: these properties will be set for all titles\nin the current titleset"));
}

bool AVPropDlg::SetValues() {
	int n = 0;
	if (!m_menu) {
		m_video->SetFormat(Auto2String(GetString(n++)));
		m_video->SetResolution(Auto2String(GetString(n++)));
		m_video->SetAspect((AspectRatio) GetInt(n++));
	}
	m_video->SetCaption(Auto2String(GetString(n++)));
	m_video->SetWidescreen((WidescreenType) GetInt(n++));
	return true;
}
