/////////////////////////////////////////////////////////////////////////////
// Name:        SubtitlePropDlg.h
// Purpose:     The subtitle properties dialog
// Author:      Alex Thuering
// Created:     24.02.2010
// RCS-ID:      $Id: SubtitlePropDlg.h,v 1.3 2011/02/20 18:55:09 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef SUBTITLE_PROP_DLG_H
#define SUBTITLE_PROP_DLG_H

#include "DVD.h"
#include <map>

// begin wxGlade: ::dependencies
#include <wx/spinctrl.h>
// end wxGlade

// begin wxGlade: ::extracode

// end wxGlade

using namespace std;
typedef map<wxString, map<wxString, wxString> > FontMap;

class SubtitlePropDlg: public wxDialog {
public:
    // begin wxGlade: SubtitlePropDlg::ids
    enum {
        FONT_FAMILY_BOX_ID  =  7900,
        FONT_STYLE_BOX_ID  =  7901,
        FONT_SIZE_SPIN_ID  =  7902,
        FONT_SIZE_BOX_ID  =  7903
    };
    // end wxGlade
    
    /**
     * Constructor
     */
    SubtitlePropDlg(wxWindow* parent, TextSub* textsub, const wxString& langCode);
    
    /**
     * Displays dialog
     */
    virtual int ShowModal();
    
    /**
     * Returns selected language code
     */
    wxString GetLangCode();
    
    /**
     * Returns font map (font family -> font style -> font filename)
     */
    static FontMap& GetFontMap();

private:
    // begin wxGlade: SubtitlePropDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade

    // begin wxGlade: SubtitlePropDlg::attributes
    wxStaticBox* boxSizer2_staticbox;
    wxStaticBox* boxSizer1_staticbox;
    wxStaticText* m_langLabel;
    wxChoice* m_langChoice;
    wxStaticText* m_charsetLabel;
    wxChoice* m_charsetChoice;
    wxStaticText* m_fontLabel;
    wxListBox* m_fontFamilyBox;
    wxListBox* m_fontStyleBox;
    wxSpinCtrl* m_fontSizeSpin;
    wxListBox* m_fontSizeBox;
    wxStaticText* m_previewLabel;
    wxTextCtrl* m_previewText;
    wxStaticText* m_fillLabel;
    wxPanel* m_fillPanel;
    wxButton* m_fillBt;
    wxStaticText* m_outlineLabel;
    wxPanel* m_outlinePanel;
    wxButton* m_outlineBt;
    wxStaticText* m_thicknessLabel;
    wxTextCtrl* m_thicknessCtrl;
    wxStaticText* m_shadowLabel;
    wxPanel* m_shadowPanel;
    wxButton* m_shadowBt;
    wxStaticText* m_offsetLabel;
    wxSpinCtrl* m_offsetXCtrl;
    wxSpinCtrl* m_offsetYCtrl;
    wxRadioButton* m_alignRadioTL;
    wxRadioButton* m_alignRadioTC;
    wxRadioButton* m_alignRadioTR;
    wxRadioButton* m_alignRadioCL;
    wxRadioButton* m_alignRadioCR;
    wxRadioButton* m_alignRadioBL;
    wxRadioButton* m_alignRadioBC;
    wxRadioButton* m_alignRadioBR;
    wxSpinCtrl* m_marginTop;
    wxSpinCtrl* m_marginLeft;
    wxSpinCtrl* m_marginRight;
    wxSpinCtrl* m_marginBottom;
    wxButton* okBt;
    wxButton* m_cancelBt;
    // end wxGlade
    
    TextSub* m_textsub;
    wxString m_langCode;
    static FontMap s_fonts;
    virtual void OnFontFamilySelected(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnFontStyleSelected(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnFontSizeChanged(wxSpinEvent &event); // wxGlade: <event_handler>
    virtual void OnFontSizeSelected(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnSelectFillColor(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnSelectOutlineColor(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnSelectShadowColor(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnFontChanged();
    
    wxColour GetFillColour() { return m_fillPanel->GetBackgroundColour(); }
    void SetFillColour(const wxColour& value) { m_fillPanel->SetBackgroundColour(value); m_fillPanel->Refresh(); }
    
    wxColour GetOutlineColour() { return m_outlinePanel->GetBackgroundColour(); }
    void SetOutlineColour(const wxColour& value) { m_outlinePanel->SetBackgroundColour(value); m_outlinePanel->Refresh(); }
    
    wxColour GetShadowColour() { return m_shadowPanel->GetBackgroundColour(); }
    void SetShadowColour(const wxColour& value) { m_shadowPanel->SetBackgroundColour(value); m_shadowPanel->Refresh(); }
    
protected:
    DECLARE_EVENT_TABLE()
}; // wxGlade: end class


#endif // SUBTITLE_PROP_DLG_H
