/////////////////////////////////////////////////////////////////////////////
// Name:        mediaenc.h
// Purpose:     Media Encoder Interface
// Author:      Alex Thuering
// Created:     24.02.2007
// RCS-ID:      $Id: mediaenc.h,v 1.7 2011/02/20 18:51:35 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef WX_MEDIA_ENCODER_H
#define WX_MEDIA_ENCODER_H

#include <wx/image.h>

enum VideoFormat {
	vfNONE = 0,
	vfCOPY,
	vfPAL,
	vfNTSC,
	vfPAL_CROPPED,
	vfNTSC_CROPPED,
	vfPAL_HALF_D1,
	vfNTSC_HALF_D1,
	vfPAL_VCD,
	vfNTSC_VCD
};

enum AudioFormat {
	afNONE = 0,
	afCOPY,
	afMP2,
	afAC3
};

enum SubtitleFormat {
	sfNONE = 0,
	sfCOPY,
	sfDVD
};

enum AspectRatio {
	arAUTO = 0,
	ar4_3,
	ar16_9
};

/** Returns frame size of given video format */
wxSize GetFrameSize(VideoFormat format);
/** Returns frame aspect ratio */
double GetFrameAspectRatio(VideoFormat format, AspectRatio aspect);
/** Returns true if video format is NTSC */
bool isNTSC(VideoFormat format);

class wxMediaEncoder {
  public:
	virtual ~wxMediaEncoder() {}
	virtual bool BeginEncode(const wxString& fileName, VideoFormat videoFormat,
			AudioFormat audioFormat, AspectRatio aspectRatio = ar4_3, int videoBitrate = 6000) = 0;
	virtual bool EncodeImage(wxImage image, int frames = 1, bool* canceled = NULL) = 0;
	virtual void EndEncode() = 0;
};

#endif // WX_MEDIA_ENCODER_H
