/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SnapshotDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class CreateSnapshot
extends BaseCmd {
    public CreateSnapshot(String[] args) {
        super("ec2addsnap", "ec2-create-snapshot");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "VOLUME";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Create a snapshot of a volume.");
        System.out.println("     The VOLUME parameter is the name of an existing volume.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("volume");
        String volumeId = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        RequestResultPair rsp = jec2.createSnapshot(volumeId);
        if (rsp.getResponse() != null) {
            out.output(System.out, (SnapshotDescription)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new CreateSnapshot(args).invoke();
    }
}

