/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AssociateAddress
extends BaseCmd {
    private static final String INSTANCE_DESC = "Instance to associate the elastic IP address with.";

    public AssociateAddress(String[] args) {
        super("ec2assocaddr", "ec2-associate-address");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)INSTANCE_DESC);
        result.addOption(OptionBuilder.create((String)"i"));
        return result;
    }

    protected String getOptionString() {
        return "IP -i INSTANCE";
    }

    public void printOptions() {
        super.printOptions();
        this.printOption("instance");
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Associate a public address with an instance.");
        System.out.println("     The IP parameter is the address to associate.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("IP");
        String publicIp = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        this.assertOptionSet("instance");
        String instanceId = this.getOptionValue("instance");
        RequestResultPair res = jec2.associateAddress(publicIp, instanceId);
        if (((Boolean)res.getResponse()).booleanValue()) {
            out.outputAddress(System.out, publicIp, instanceId);
            out.printRequestId(System.out, (RequestResult)res);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new AssociateAddress(args).invoke();
    }
}

