/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SpotInstanceRequestDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class DescribeSpotInstanceRequests
extends BaseCmd {
    public DescribeSpotInstanceRequests(String[] args) {
        super("ec2dsir", "ec2-describe-spot-instance-requests");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "[REQUESTID [REQUESTID ...]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe spot instance requests. The REQUESTID parameters, ");
        System.out.println("     if specified, are the spot instance requests to describe.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] requestIds = this.getNonOptions();
        RequestResultPair rsp = jec2.describeSpotInstanceRequests(requestIds);
        for (SpotInstanceRequestDescription desc : (List)rsp.getResponse()) {
            out.output(System.out, desc);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeSpotInstanceRequests(args).invoke();
    }
}

