/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.BlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SpotInstanceRequestDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.cli.Options;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestSpotInstances
extends BaseCmd {
    private static final String[] PRICE_DESC = new String[]{"Specifies the maximum hourly price for any spot instance launched to", "fulfill the request."};
    private static final String PRICE_ARG = "PRICE";
    private static final String[] INSTANCE_COUNT_DESC = new String[]{"The maximum number of spot instances to launch."};
    private static final String INSTANCE_COUNT_ARG = "COUNT";
    private static final String[] VALID_FROM_DESC = new String[]{"The date and time after which the spot instance reuqest will be", "considered for fulfillment; specified in the format ", "'yyyy-MM-ddTHH:mm:ss'."};
    private static final String VALID_FROM_ARG = "VALIDFROM";
    private static final String[] VALID_UNTIL_DESC = new String[]{"The date and time after which the spot instance request will expire", "and no longer be considered for fulfillment; specified in the format ", "'yyyy-MM-ddTHH:mm:ss'."};
    private static final String VALID_UNTIL_ARG = "VALIDUNTIL";
    private static final String[] REQUEST_TYPE_DESC = new String[]{"Specified the spot instance request type; either 'one-time' or ", "'persistent'."};
    private static final String REQUEST_TYPE_ARG = "REQUEST";
    private static final String[] LAUNCH_GROUP_DESC = new String[]{"Specifies the spot instance launch group."};
    private static final String LAUNCH_GROUP_ARG = "GROUP";
    private static final String[] AZ_GROUP_DESC = new String[]{"Specifies the spot instance availability zone group."};
    private static final String AZ_GROUP_ARG = "GROUP";
    private static final String[] IMAGE_DESC = new String[]{"The ID of the Amazon Machine Image (AMI)."};
    private static final String[] RAMDISK_DESC = new String[]{"Specifies the ID of the ramdisk to launch the instance(s) with."};
    private static final String RAMDISK_ARG = "RAMDISK";
    private static final String[] KERNEL_DESC = new String[]{"Specifies the ID of the kernel to launch the instance(s) with."};
    private static final String KERNEL_ARG = "KERNEL";
    private static final String[] AVAILABILITY_ZONE_DESC = new String[]{"Specifies the availability zone to launch the instance(s) in. Run the", "'ec2-describe-availability-zones' command for a list of values, and", "see the latest Developer's Guide for their meanings."};
    private static final String AVAILABILITY_ZONE_ARG = "ZONE";
    private static final String PROFILE_ARG = "PROFILE";
    private static final String[] PROFILE_DESC = new String[]{"Specifies the operating-system profile to launch instances with.", "Refer to the latest Developer's Guide for acceptable profile values."};
    private static final String[] INSTANCE_TYPE_DESC = new String[]{"Specifies the type of instance to be launched. Refer to the latest", "Developer's Guide for valid values."};
    private static final String INSTANCE_TYPE_ARG = "TYPE";
    private static final String[] ADDRESSING_DESC = new String[]{"Specifies the addressing type to use for the instance(s). Refer to the", "latest Developer's Guide for valid values."};
    private static final String ADDRESSING_ARG = "ADDRESSING";
    private static final String[] USER_DATA_FILE_DESC = new String[]{"Specifies the file containing user data to be made available to the", "instance(s) in this reservation."};
    private static final String USER_DATA_FILE_ARG = "DATA-FILE";
    private static final String[] USER_DATA_DESC = new String[]{"Specifies the user data to be made available to the instance(s) in", "this reservation."};
    private static final String USER_DATA_ARG = "DATA";
    private static final String[] KEY_ID_DESC = new String[]{"Specifies the key pair to use when launching the instance(s)."};
    private static final String KEY_ID_ARG = "KEY-PAIR";
    private static final String[] GROUP_DESC = new String[]{"Specifies the security group (or groups if specified multiple times)", "within which the instance(s) should be run. Determines the ingress", "firewall rules that will be applied to the launched instances.", "Defaults to the user's default group if not supplied."};
    private static final String GROUP_ARG = "GROUP [--group GROUP...]";
    private static final String[] BLOCK_DEVICE_MAPPING_DESC = new String[]{"Defines a block device mapping for the instance(s), in the form", "'<device>=<block-device>', where 'block-device' can be one of the", "following:", "", " - 'none': indicates that a block device that would be exposed at the", "   specified device should be suppressed. For example: '/dev/sdb=none'", "", " - 'ephemeral[0-3]': indicates that the Amazon EC2 ephemeral store", "   (instance local storage) should be exposed at the specified device.", "   For example: '/dev/sdc=ephemeral0'.", "", " - '[<snapshot-id>][:<size>[:<delete-on-termination>]]': indicates", "   that an Amazon EBS volume, created from the specified Amazon EBS", "   snapshot, should be exposed at the specified device. The following", "   combinations are supported:", "", "    - '<snapshot-id>': the ID of an Amazon EBS snapshot, which must", "      be owned by or restorable by the caller. May be left out if a", "      <size> is specified, creating an empty Amazon EBS volume of", "      the specified size.", "", "    - '<size>': the size (GiBs) of the Amazon EBS volume to be", "      created. If a snapshot was specified, this may not be smaller", "      than the size of the snapshot itself.", "", "    - '<delete-on-termination>': indicates whether the Amazon EBS", "      volume should be deleted on instance termination. If not", "      specified, this will default to 'true' and the volume will be", "      deleted.", "", "   For example: '/dev/sdb=snap-7eb96d16'", "                '/dev/sdc=snap-7eb96d16:80:false'", "                '/dev/sdd=:120'", "", "See the latest Developer's Guide for further information."};
    private static final String[] MONITORING_DESC = new String[]{"Enables monitoring of the specified instance(s)."};
    private static final String BLOCK_DEVICE_MAPPING_ARG = "MAPPING";
    private static final String[] SUBNET_DESC = new String[]{"The ID of the Amazon VPC subnet in which to launch the instance(s)."};
    private boolean monitoring = false;
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public RequestSpotInstances(String[] args) {
        super("ec2rsi", "ec2-request-spot-instances");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
        if (this.cmd == null) {
            return;
        }
        this.monitoring = this.cmd.hasOption("monitoring");
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(RequestSpotInstances.createOptionWithArgs("n", "instance-count", INSTANCE_COUNT_DESC, INSTANCE_COUNT_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs("p", "price", PRICE_DESC, PRICE_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs("r", "type", REQUEST_TYPE_DESC, REQUEST_TYPE_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs(null, "valid-from", VALID_FROM_DESC, VALID_FROM_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs(null, "valid-until", VALID_UNTIL_DESC, VALID_UNTIL_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs(null, "launch-group", LAUNCH_GROUP_DESC, "GROUP"));
        result.addOption(RequestSpotInstances.createOptionWithArgs(null, "availability-zone-group", AZ_GROUP_DESC, "GROUP"));
        result.addOption(RequestSpotInstances.createOptionWithArgs("b", "block-device-mapping", BLOCK_DEVICE_MAPPING_DESC, BLOCK_DEVICE_MAPPING_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs("d", "user-data", USER_DATA_DESC, USER_DATA_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs("f", "user-data-file", USER_DATA_FILE_DESC, USER_DATA_FILE_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs("g", "group", GROUP_DESC, GROUP_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs("k", "key", KEY_ID_DESC, KEY_ID_ARG));
        result.addOption(RequestSpotInstances.createOption("m", "monitor", MONITORING_DESC));
        result.addOption(RequestSpotInstances.createOptionWithArgs("n", "instance-count", INSTANCE_COUNT_DESC, INSTANCE_COUNT_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs("s", "subnet", SUBNET_DESC, "SUBNET"));
        result.addOption(RequestSpotInstances.createOptionWithArgs("t", "instance-type", INSTANCE_TYPE_DESC, INSTANCE_TYPE_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs("z", "availability-zone", AVAILABILITY_ZONE_DESC, AVAILABILITY_ZONE_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs(null, "addressing", ADDRESSING_DESC, ADDRESSING_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs(null, "kernel", KERNEL_DESC, KERNEL_ARG));
        result.addOption(RequestSpotInstances.createOptionWithArgs(null, "properties", new String[0], "PROPERTIES"));
        result.addOption(RequestSpotInstances.createOptionWithArgs(null, "ramdisk", RAMDISK_DESC, RAMDISK_ARG));
        result.addOption(RequestSpotInstances.createOption(null, "monitoring", MONITORING_DESC));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "AMI [SPECIFIC OPTIONS]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a spot instance request.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("block-device-mapping");
        this.printOption("user-data");
        this.printOption("user-data-file");
        this.printOption("group");
        this.printOption("key");
        this.printOption("monitor");
        this.printOption("instance-count");
        this.printOption("price");
        this.printOption("type");
        this.printOption("subnet");
        this.printOption("instance-type");
        this.printOption("availability-zone");
        this.printOption("addressing");
        this.printOption("availability-zone-group");
        this.printOption("kernel");
        this.printOption("launch-group");
        this.printOption("ramdisk");
        this.printOption("valid-from");
        this.printOption("valid-until");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertOptionSet("price");
        String price = null;
        if (this.isOptionSet("price")) {
            price = this.getOptionValue("price");
        }
        String userData = null;
        if (this.isOptionSet("user-data") && this.isOptionSet("user-data-file")) {
            throw new InvalidArgumentCombination("You may not specify both user data on the command line (-d) and a file containing user data (-f).");
        }
        if (this.isOptionSet("user-data")) {
            userData = this.getUserData(this.getOptionValue("user-data"));
        } else if (this.isOptionSet("user-data-file")) {
            userData = this.getUserDataFile(this.getOptionValue("user-data-file"));
        }
        String instanceCount = null;
        if (this.isOptionSet("instance-count")) {
            instanceCount = this.getOptionValue("instance-count", "1");
        }
        String requestType = null;
        if (this.isOptionSet("type")) {
            requestType = this.getOptionValue("type");
        }
        GregorianCalendar validFrom = null;
        String validFromValue = null;
        if (this.isOptionSet("valid-from")) {
            validFromValue = this.getOptionValue("valid-from");
            Date localDate = dateFormat.parse(validFromValue);
            validFrom = new GregorianCalendar();
            validFrom.setTimeZone(TimeZone.getTimeZone("UTC"));
            validFrom.setTime(localDate);
        }
        GregorianCalendar validUntil = null;
        String validUntilValue = null;
        if (this.isOptionSet("valid-until")) {
            validUntilValue = this.getOptionValue("valid-until");
            Date localDate = dateFormat.parse(validUntilValue);
            validUntil = new GregorianCalendar();
            validUntil.setTimeZone(TimeZone.getTimeZone("UTC"));
            validUntil.setTime(localDate);
        }
        String launchGroup = null;
        if (this.isOptionSet("launch-group")) {
            launchGroup = this.getOptionValue("launch-group");
        }
        String availabilityZoneGroup = null;
        if (this.isOptionSet("availability-zone-group")) {
            availabilityZoneGroup = this.getOptionValue("availability-zone-group");
        }
        String props = null;
        if (this.isOptionSet("properties")) {
            props = this.getOptionValue("properties");
        }
        String keyId = null;
        if (this.isOptionSet("key")) {
            keyId = this.getOptionValue("key");
        }
        String availabilityZone = this.getOptionValue("availability-zone");
        String addressing = this.getOptionValue("addressing");
        this.assertNonOptionSet("AMI");
        this.warnIfTooManyNonOptions();
        String imageId = this.getNonOptions()[0];
        List<String> groupIds = Arrays.asList(this.getOptionValues("group"));
        String instanceType = this.getOptionValue("instance-type", "m1.small");
        String kernel = null;
        if (this.isOptionSet("kernel")) {
            kernel = this.getOptionValue("kernel");
        }
        String ramdisk = null;
        if (this.isOptionSet("ramdisk")) {
            ramdisk = this.getOptionValue("ramdisk");
        }
        boolean monitoring = this.isOptionSet("monitor") || this.isOptionSet("monitoring");
        String subnetId = null;
        if (this.isOptionSet("subnet")) {
            subnetId = this.getOptionValue("subnet");
        }
        List<BlockDeviceMappingDescription> blockDeviceMapping = this.getBlockDeviceMapping(this.getOptionValues("block-device-mapping"));
        RequestResultPair rsp = jec2.requestSpotInstances(price, imageId, groupIds, keyId, addressing, instanceType, availabilityZone, this.getOptionValue("subnet"), kernel, ramdisk, blockDeviceMapping, Boolean.valueOf(monitoring), userData, instanceCount, requestType, validUntil, validFrom, launchGroup, availabilityZoneGroup);
        for (SpotInstanceRequestDescription desc : (List)rsp.getResponse()) {
            out.output(System.out, desc);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected List<BlockDeviceMappingDescription> getBlockDeviceMapping(String[] blockDeviceOptions) {
        ArrayList<BlockDeviceMappingDescription> blockDevices = new ArrayList<BlockDeviceMappingDescription>();
        if (blockDeviceOptions == null || blockDeviceOptions.length == 0) {
            return blockDevices;
        }
        for (String blockDeviceOption : blockDeviceOptions) {
            try {
                blockDevices.add(BlockDeviceMappingDescription.valueOf((String)blockDeviceOption));
            }
            catch (Exception e) {
                throw new InvalidArgument("block-device-mapping", blockDeviceOption);
            }
        }
        return blockDevices;
    }

    private String getUserDataFile(String str) throws IOException {
        String base64 = null;
        File file = new File(str);
        if (file.canRead() && file.isFile()) {
            try {
                int content_length = (int)file.length();
                FileInputStream ifs = new FileInputStream(file);
                byte[] contents = new byte[content_length];
                int nread = ifs.read(contents);
                assert (nread == content_length);
                base64 = new BASE64Encoder().encode(contents);
            }
            catch (FileNotFoundException nfe) {
                System.err.println("File not found? This is of course impossible.\n" + nfe.toString());
                throw nfe;
            }
        } else {
            throw new InvalidArgument("user-data-file", str);
        }
        return base64.replaceAll("\\s", "");
    }

    private String getUserData(String str) {
        String base64 = new BASE64Encoder().encodeBuffer(str.getBytes());
        return base64.replaceAll("\\s", "");
    }

    public static void main(String[] args) {
        new RequestSpotInstances(args).invoke();
    }
}

