/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeNetworkAcls
extends BaseCmd {
    public DescribeNetworkAcls(String[] args) {
        super("ec2dnacl", "ec2-describe-network-acls");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        o.addOption(OptionBuilder.create((String)"F"));
        return o;
    }

    public String getOptionString() {
        return "[NETWORK_ACL [NETWORK_ACL [...]]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Describe either all network ACLs belonging to a user, or specific ACLs designated by IDs.");
        System.out.println("     NETWORK_ACL is the id(s) of the Network ACL(s) to describe.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.warnIfTooManyNonOptions();
        RequestResultPair results = jec2.describeNetworkAcls(this.getNonOptions(), this.getFilters(true));
        out.outputNetworkAclDescriptions(System.out, (List)results.getResponse());
        out.printRequestId(System.out, (RequestResult)results);
        return true;
    }

    public static void main(String[] args) {
        new DescribeNetworkAcls(args).invoke();
    }
}

