/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

import com.amazon.aes.webservices.client.IamInstanceProfile;
import com.amazon.aes.webservices.client.InstanceBlockDeviceMappingResponseDescription;
import com.amazon.aes.webservices.client.InstanceLicense;
import com.amazon.aes.webservices.client.InstanceNetworkInterface;
import com.amazon.aes.webservices.client.InstancePlacement;
import com.amazon.aes.webservices.client.MonitorInstance;
import com.amazon.aes.webservices.client.ProductCodeDescription;
import com.amazon.aes.webservices.client.ResourceTagDescription;
import com.amazonaws.ec2.doc._2012_07_20.InstanceStateType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ReservationDescription {
    public String owner;
    public String resId;
    public List<Instance> instances = new ArrayList<Instance>();
    public List<String> groups = new ArrayList<String>();
    public String requesterId = null;

    public ReservationDescription(String owner, String resId, String requesterId) {
        this.owner = owner;
        this.resId = resId;
        this.requesterId = requesterId;
    }

    public Instance addInstance(Instance instance) {
        this.instances.add(instance);
        return instance;
    }

    public Instance addInstance(String imageId, String instanceId, String dnsName, String privateDnsName, InstanceStateType state, String reason, String keyName, String amiLaunchIndex, List<ProductCodeDescription> productCodes, String instanceType, Calendar launchTime, InstancePlacement placement, String kernelId, String ramdiskId, String platform, String monitoring, String vpcId, String subnetId, String publicIpAddress, String privateIpAddress, String rootDeviceType, String virtualizationType, String hypervisor, List<InstanceBlockDeviceMappingResponseDescription> blockDevices, String instanceClass, String spotInstanceRequestId, InstanceLicense license, List<InstanceNetworkInterface> networkInterfaceAttachments, Boolean ebsOptimized, IamInstanceProfile iamInstanceIdentityProfile, String clientToken, List<ResourceTagDescription> tags, List<String> groups) {
        Instance instance = new Instance(imageId, instanceId, dnsName, privateDnsName, state.getName(), state.getCode(), reason, keyName, amiLaunchIndex, productCodes, instanceType, launchTime, placement, kernelId, ramdiskId, platform, MonitorInstance.MonitoringState.valueOf(monitoring), vpcId, subnetId, publicIpAddress, privateIpAddress, rootDeviceType, virtualizationType, hypervisor, blockDevices, instanceClass, spotInstanceRequestId, license, networkInterfaceAttachments, ebsOptimized, iamInstanceIdentityProfile, clientToken, tags, groups);
        this.instances.add(instance);
        return instance;
    }

    public String addGroup(String groupId) {
        this.groups.add(groupId);
        return groupId;
    }

    public String toString() {
        return "Reservation[id=" + this.resId + ", Loc=" + ", instances=" + this.instances + ", groups=" + this.groups + "]";
    }

    public static class Instance {
        public String imageId;
        public String instanceId;
        public String dnsName;
        public String privateDnsName;
        public String reason;
        public String keyName;
        public String amiLaunchIndex;
        public List<ProductCodeDescription> productCodes;
        public String instanceType;
        public Calendar launchTime;
        public String state;
        public int stateCode;
        public InstancePlacement placement;
        public String ramdiskId;
        public String kernelId;
        public String platform;
        public MonitorInstance.MonitoringState monitoring;
        public String vpcId;
        public String subnetId;
        public String publicIpAddress;
        public String privateIpAddress;
        public String rootDeviceType;
        public String virtualizationType;
        public String hypervisor;
        public List<InstanceBlockDeviceMappingResponseDescription> blockDevices;
        public String instanceLifecycle;
        public String spotInstanceRequestId;
        public InstanceLicense license;
        public List<InstanceNetworkInterface> networkInterfaceAttachments;
        public Boolean ebsOptimized;
        public IamInstanceProfile iamInstanceIdentityProfile;
        public String clientToken;
        public List<ResourceTagDescription> tags;
        public List<String> groups;

        public Instance(String imageId, String instanceId, String dnsName, String privateDnsName, String stateName, int stateCode, String reason, String keyName, String amiLaunchIndex, List<ProductCodeDescription> productCodes, String instanceType, Calendar launchTime, InstancePlacement placement, String kernelId, String ramdiskId, String platform, MonitorInstance.MonitoringState monitoring, String vpcId, String subnetId, String publicIpAddress, String privateIpAddress, String rootDeviceType, String virtualizationType, String hypervisor, List<InstanceBlockDeviceMappingResponseDescription> blockDevices, String instanceLifecycle, String spotInstanceRequestId, InstanceLicense license, List<InstanceNetworkInterface> networkInterfaceAttachments, Boolean ebsOptimized, IamInstanceProfile iamInstanceIdentityProfile, String clientToken, List<ResourceTagDescription> tags, List<String> groups) {
            this.imageId = imageId;
            this.instanceId = instanceId;
            this.dnsName = dnsName;
            this.privateDnsName = privateDnsName;
            this.state = stateName;
            this.stateCode = stateCode;
            this.reason = reason;
            this.keyName = keyName;
            this.amiLaunchIndex = amiLaunchIndex;
            this.productCodes = productCodes;
            this.instanceType = instanceType;
            this.launchTime = launchTime;
            this.placement = placement;
            this.ramdiskId = ramdiskId;
            this.kernelId = kernelId;
            this.platform = platform;
            this.monitoring = monitoring;
            this.vpcId = vpcId;
            this.subnetId = subnetId;
            this.publicIpAddress = publicIpAddress;
            this.privateIpAddress = privateIpAddress;
            this.rootDeviceType = rootDeviceType;
            this.virtualizationType = virtualizationType;
            this.hypervisor = hypervisor;
            this.blockDevices = blockDevices;
            this.instanceLifecycle = instanceLifecycle;
            this.spotInstanceRequestId = spotInstanceRequestId;
            this.license = license;
            this.networkInterfaceAttachments = networkInterfaceAttachments;
            this.ebsOptimized = ebsOptimized;
            this.iamInstanceIdentityProfile = iamInstanceIdentityProfile;
            this.clientToken = clientToken;
            this.tags = tags;
            this.groups = groups;
        }

        public boolean isRunning() {
            return this.state.equalsIgnoreCase("running");
        }

        public boolean isPending() {
            return this.state.equalsIgnoreCase("pending");
        }

        public boolean isShuttingDown() {
            return this.state.equalsIgnoreCase("shutting-down");
        }

        public boolean isTerminated() {
            return this.state.equalsIgnoreCase("terminated");
        }

        public String toString() {
            return "[img=" + this.imageId + ", instance=" + this.instanceId + ", dns=" + this.dnsName + ", privateDns=" + this.privateDnsName + ", loc=" + ", state=" + this.state + "(" + this.stateCode + ") reason=" + this.reason + ", amiLaunchIndex=" + this.amiLaunchIndex + ", productCodes=" + this.productCodes + "]" + ", instanceType=" + this.instanceType + ", launchTime=" + this.launchTime + ", placement=" + this.placement + ", ramdiskId = " + this.ramdiskId + ", kernelId = " + this.kernelId + ", platform = " + this.platform + ", monitoring = monitoring-" + this.monitoring.state + ", instanceLifecycle = " + this.instanceLifecycle + ", spotInstanceRequestId = " + this.spotInstanceRequestId + ", license = " + this.license + ", iamInstanceIdentityProfileArn = " + this.iamInstanceIdentityProfile + ", clientToken = " + this.clientToken + "]";
        }
    }
}

