/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ConsoleOutput;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class GetConsoleOutput
extends BaseCmd {
    private static final String[] RAW_CONSOLE_OUTPUT_DESC = new String[]{"Raw output. Do not escape the console output. If not specified ^ESC", "is escaped and multiple blank-lines are folded into one."};

    public GetConsoleOutput(String[] args) {
        super("ec2gcons", "ec2-get-console-output");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        result.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"raw-console-output");
        OptionBuilder.withDescription((String)GetConsoleOutput.joinDescription(RAW_CONSOLE_OUTPUT_DESC));
        result.addOption(OptionBuilder.create((String)"r"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "[-r] INSTANCE";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Display the instance's console output");
        System.out.println("     The INSTANCE parameter is the ID of the instance's console to retrieve.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("raw-console-output");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("INSTANCE");
        this.warnIfTooManyNonOptions();
        String instanceId = this.getNonOptions()[0];
        RequestResultPair rsp = jec2.getConsoleOutput(instanceId);
        out.outputConsoleOutput(System.out, (ConsoleOutput)rsp.getResponse(), this.isOptionSet("raw-console-output"));
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new GetConsoleOutput(args).invoke();
    }
}

