/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.BlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.IamInstanceProfileRequestDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.NetworkInterfaceAttachmentRequestDescription;
import com.amazon.aes.webservices.client.PlacementDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.ReservationDescription;
import com.amazon.aes.webservices.client.Tenancy;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.cmd.util.LaunchUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.Options;
import sun.misc.BASE64Encoder;

public class RunInstances
extends BaseCmd {
    private static final String[] RAMDISK_DESC = new String[]{"Specifies the ID of the ramdisk to launch the instance(s) with."};
    private static final String RAMDISK_ARG = "RAMDISK";
    private static final String[] KERNEL_DESC = new String[]{"Specifies the ID of the kernel to launch the instance(s) with."};
    private static final String KERNEL_ARG = "KERNEL";
    private static final String[] AVAILABILITY_ZONE_DESC = new String[]{"Specifies the availability zone to launch the instance(s) in. Run the", "'ec2-describe-availability-zones' command for a list of values, and", "see the latest Developer's Guide for their meanings."};
    private static final String AVAILABILITY_ZONE_ARG = "ZONE";
    private static final String PROFILE_ARG = "PROFILE";
    private static final String[] PROFILE_DESC = new String[]{"Specifies the operating-system profile to launch instances with.", "Refer to the latest Developer's Guide for acceptable profile values."};
    private static final String[] INSTANCE_TYPE_DESC = new String[]{"Specifies the type of instance to be launched. Refer to the latest", "Developer's Guide for valid values."};
    private static final String INSTANCE_TYPE_ARG = "TYPE";
    private static final String[] ADDRESSING_DESC = new String[]{"Specifies the addressing type to use for the instance(s). Refer to the", "latest Developer's Guide for valid values."};
    private static final String ADDRESSING_ARG = "ADDRESSING";
    private static final String[] USER_DATA_FILE_DESC = new String[]{"Specifies the file containing user data to be made available to the", "instance(s) in this reservation."};
    private static final String USER_DATA_FILE_ARG = "DATA-FILE";
    private static final String[] USER_DATA_DESC = new String[]{"Specifies the user data to be made available to the instance(s) in", "this reservation."};
    private static final String USER_DATA_ARG = "DATA";
    private static final String[] KEY_ID_DESC = new String[]{"Specifies the name of the key pair to use when launching the instance(s)."};
    private static final String KEY_ID_ARG = "KEYPAIR";
    private static final String[] GROUP_DESC = new String[]{"Specifies the security group (or groups if specified multiple times)", "within which the instance(s) should be run. Determines the ingress", "firewall rules that will be applied to the launched instances.", "Defaults to the user's default group if not supplied."};
    private static final String GROUP_ARG = "GROUP [--group GROUP...]";
    private static final String[] INSTANCE_COUNT_DESC = new String[]{"The number of instances to attempt to launch. May be specified as a", "single integer or as a range (min-max). This specifies the minimum", "and maximum number of instances to attempt to launch. If a single", "integer is specified min and max are both set to that value."};
    private static final String INSTANCE_COUNT_ARG = "MIN[-MAX]";
    private static final String[] MONITORING_DESC = new String[]{"Enables monitoring of the specified instance(s)."};
    private static final String BLOCK_DEVICE_MAPPING_ARG = "MAPPING";
    private static final String[] SUBNET_DESC = new String[]{"The ID of the Amazon VPC subnet in which to launch the instance(s)."};
    private static final String[] DISABLE_API_TERMINATION_DESC = new String[]{"Indicates that the instance(s) may not be terminated using the", "TerminateInstances API call."};
    private static final String[] INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_DESC = new String[]{"Indicates what the instance(s) should do if an on instance shutdown", "is issued. The following values are supported", "", " - 'stop': indicates that the instance should move into the stopped", "    state and remain available to be restarted.", "", " - 'terminate': indicates that the instance should move into the", "    terminated state."};
    private static final String LICENSE_POOL_ARG = "LICENSE_POOL";
    private static final String[] LICENSE_POOL_DESC = new String[]{"Specifies the license pool to use when launching the instance(s)."};
    private static final String IP_ADDRESS_ARG = "IP_ADDRESS";
    private static final String[] PRIVATE_IP_DESC = new String[]{"Specifies the private IP address to use when launching an ", "Amazon VPC instance."};
    private static final String CLIENT_TOKEN = "client-token";
    private static final String CLIENT_TOKEN_ARG = "TOKEN";
    private static final String CLIENT_TOKEN_DESC = "Client token for idempotency.";
    private static final String[] TENANCY_DESC = new String[]{"Specifies the tenancy of an instance, which can be default or dedicated.", " - default: The default tenancy.", " - dedicated: The instance does not share hardware with instances", "   launched from other accounts (additional charges apply).", " This option is only available for VPC instances."};
    private static final String[] NETWORK_ATTACHMENT_DESC = new String[]{"Specifies the network attachment for the instance to launch.", "The format of the attachment definition is as follows:", "<nic>:<dev index>[:<subnet>[:<description>[:<priv IP>[:<SGs>[:<DOT>", "[:SIP count[:<SIPs>]]]]]]], where:", "- SGs is a comma separated list of security group IDs.", "- DOT is either true or false, denoting whether to delete the interface ", "  on termination.", "- SIP count is the count of secondary private IP addresses.", "- SIPs is a list of secondary private IP addresses.", "Specify only one of SIP count or SIPs."};
    private static final String[] SECONDARY_PRIVATE_IP_ADDRESS_DESC = new String[]{"The secondary private IP address to assign to the specified network", "interface of the instance to be launched."};
    private static final String[] SECONDARY_PRIVATE_IP_COUNT_DESC = new String[]{"The number of secondary private IP addresses to be automatically", "assigned to the specified network interface of the instance to", "be launched."};
    private static final String[] IAM_PROFILE_DESC = new String[]{"Specifies the IAM profile to associate with the launched instance(s).", "IAM profiles enable you to manage permissions for applications running on EC2.", "This is either the ARN of the profile or the name of the role."};

    public RunInstances(String[] args) {
        super("ec2run", "ec2-run-instances");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(RunInstances.createOptionWithArgs("b", "block-device-mapping", BLOCK_DEVICE_MAPPING_DESC, BLOCK_DEVICE_MAPPING_ARG));
        result.addOption(RunInstances.createOptionWithArgs("d", "user-data", USER_DATA_DESC, USER_DATA_ARG));
        result.addOption(RunInstances.createOptionWithArgs("f", "user-data-file", USER_DATA_FILE_DESC, USER_DATA_FILE_ARG));
        result.addOption(RunInstances.createOptionWithArgs("g", "group", GROUP_DESC, GROUP_ARG));
        result.addOption(RunInstances.createOptionWithArgs("k", "key", KEY_ID_DESC, KEY_ID_ARG));
        result.addOption(RunInstances.createOption("m", "monitor", MONITORING_DESC));
        result.addOption(RunInstances.createOptionWithArgs("n", "instance-count", INSTANCE_COUNT_DESC, INSTANCE_COUNT_ARG));
        result.addOption(RunInstances.createOptionWithArgs("s", "subnet", SUBNET_DESC, "SUBNET"));
        result.addOption(RunInstances.createOptionWithArgs("t", "instance-type", INSTANCE_TYPE_DESC, INSTANCE_TYPE_ARG));
        result.addOption(RunInstances.createOptionWithArgs("z", "availability-zone", AVAILABILITY_ZONE_DESC, AVAILABILITY_ZONE_ARG));
        result.addOption(RunInstances.createOptionWithArgs(null, "addressing", ADDRESSING_DESC, ADDRESSING_ARG));
        result.addOption(RunInstances.createOption(null, "disable-api-termination", DISABLE_API_TERMINATION_DESC));
        result.addOption(RunInstances.createOptionWithArgs(null, "instance-initiated-shutdown-behavior", INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_DESC, "BEHAVIOR"));
        result.addOption(RunInstances.createOptionWithArgs(null, "kernel", KERNEL_DESC, KERNEL_ARG));
        result.addOption(RunInstances.createOptionWithArgs(null, "license-pool", LICENSE_POOL_DESC, LICENSE_POOL_ARG));
        result.addOption(RunInstances.createOptionWithArgs(null, "private-ip-address", PRIVATE_IP_DESC, IP_ADDRESS_ARG));
        result.addOption(RunInstances.createOptionWithArgs(null, "properties", new String[0], "PROPERTIES"));
        result.addOption(RunInstances.createOptionWithArgs(null, "ramdisk", RAMDISK_DESC, RAMDISK_ARG));
        result.addOption(RunInstances.createOption(null, "monitoring", MONITORING_DESC));
        result.addOption(RunInstances.createOptionWithArgs(null, "placement-group", PLACEMENT_GROUP_DESC, "GROUP_NAME"));
        result.addOption(RunInstances.createOptionWithArgs(null, CLIENT_TOKEN, CLIENT_TOKEN_DESC, CLIENT_TOKEN_ARG));
        result.addOption(RunInstances.createOptionWithArgs(null, "tenancy", TENANCY_DESC, "TENANCY"));
        result.addOption(RunInstances.createOptionWithArgs(null, "ebs-optimized", EBS_OPTIMIZED_DESC, "Boolean"));
        result.addOption(RunInstances.createOptionWithArgs(null, "secondary-private-ip-address", SECONDARY_PRIVATE_IP_ADDRESS_DESC, "SECONDARY-PRIVATE-IP-ADDRESS"));
        result.addOption(RunInstances.createOptionWithArgs(null, "secondary-private-ip-address-count", SECONDARY_PRIVATE_IP_COUNT_DESC, "SECONDARY-PRIVATE-ADDRESS-COUNT"));
        result.addOption(RunInstances.createOptionWithArgs("a", "network-attachment", NETWORK_ATTACHMENT_DESC, "NETWORKATTACHMENT"));
        result.addOption(RunInstances.createOptionWithArgs("p", "iam-profile", IAM_PROFILE_DESC, "ARN"));
        return result;
    }

    @Override
    public String getOptionString() {
        return "AMI [SPECIFIC OPTIONS]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Launch a number of instances of a specified AMI.");
        System.out.println("     The AMI parameter is the AMI ID of the AMI to launch.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("block-device-mapping");
        this.printOption("user-data");
        this.printOption("user-data-file");
        this.printOption("group");
        this.printOption("key");
        this.printOption("monitor");
        this.printOption("instance-count");
        this.printOption("subnet");
        this.printOption("instance-type");
        this.printOption("availability-zone");
        this.printOption("addressing");
        this.printOption("disable-api-termination");
        this.printOption("instance-initiated-shutdown-behavior");
        this.printOption("kernel");
        this.printOption("license-pool");
        this.printOption("ramdisk");
        this.printOption("placement-group");
        this.printOption("private-ip-address");
        this.printOption("iam-profile");
        this.printOption(CLIENT_TOKEN);
        this.printOption("tenancy");
        this.printOption("ebs-optimized");
        this.printOption("network-attachment");
        this.printOption("secondary-private-ip-address");
        this.printOption("secondary-private-ip-address-count");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String instanceProfileName;
        String props = null;
        if (this.isOptionSet("properties")) {
            props = this.getOptionValue("properties");
        }
        String keyId = null;
        if (this.isOptionSet("key")) {
            keyId = this.getOptionValue("key");
        }
        String userData = null;
        if (this.isOptionSet("user-data") && this.isOptionSet("user-data-file")) {
            throw new InvalidArgumentCombination("You may not specify both user data on the command line (-d) and a file containing user data (-f).");
        }
        if (this.isOptionSet("user-data")) {
            userData = this.getUserData(this.getOptionValue("user-data"));
        } else if (this.isOptionSet("user-data-file")) {
            userData = this.getUserDataFile(this.getOptionValue("user-data-file"));
        }
        PlacementDescription placement = null;
        if (this.isOptionSet("availability-zone") || this.isOptionSet("placement-group")) {
            placement = new PlacementDescription();
            if (this.isOptionSet("availability-zone")) {
                placement.setAvailabilityZone(this.getOptionValue("availability-zone"));
            }
            if (this.isOptionSet("placement-group")) {
                placement.setGroupName(this.getOptionValue("placement-group"));
            }
        }
        String addressing = this.getOptionValue("addressing");
        this.assertNonOptionSet("AMI");
        this.warnIfTooManyNonOptions();
        String imageId = this.getNonOptions()[0];
        int[] range = this.parseRange(this.getOptionValue("instance-count", "1"));
        List<String> groupIds = Arrays.asList(this.getOptionValues("group"));
        String instanceType = this.getOptionValue("instance-type");
        String kernel = null;
        if (this.isOptionSet("kernel")) {
            kernel = this.getOptionValue("kernel");
        }
        String ramdisk = null;
        if (this.isOptionSet("ramdisk")) {
            ramdisk = this.getOptionValue("ramdisk");
        }
        boolean monitoring = this.isOptionSet("monitor") || this.isOptionSet("monitoring");
        String subnetId = null;
        if (this.isOptionSet("subnet")) {
            subnetId = this.getOptionValue("subnet");
        }
        boolean disableApiTermination = this.isOptionSet("disable-api-termination");
        String instanceInitiatedShutdownBehavior = this.getOptionValue("instance-initiated-shutdown-behavior");
        List<BlockDeviceMappingDescription> blockDeviceMapping = this.getBlockDeviceMapping(this.getOptionValues("block-device-mapping"));
        String licensePool = null;
        if (this.isOptionSet("license-pool")) {
            licensePool = this.getOptionValue("license-pool");
        }
        String primaryPrivateIpAddress = null;
        if (this.isOptionSet("private-ip-address")) {
            primaryPrivateIpAddress = this.getOptionValue("private-ip-address");
        }
        String clientToken = null;
        if (this.isOptionSet(CLIENT_TOKEN)) {
            clientToken = this.getOptionValue(CLIENT_TOKEN);
        }
        if (this.isOptionSet("tenancy")) {
            String value = this.getOptionValue("tenancy");
            Tenancy tenancy = Tenancy.toTenancy((String)value);
            if (null == tenancy) {
                throw new InvalidArgument("tenancy", value);
            }
            if (null == placement) {
                placement = new PlacementDescription();
            }
            placement.setTenancy(tenancy);
        }
        boolean ebsOptimized = this.isOptionSet("ebs-optimized");
        List<NetworkInterfaceAttachmentRequestDescription> attachments = LaunchUtil.getNetworkInterfaceAttachments(this.getOptionValues("network-attachment"));
        List<String> privateIpAddresses = null;
        String[] values = this.getOptionValues("secondary-private-ip-address");
        if (null != values && values.length > 0) {
            privateIpAddresses = Arrays.asList(values);
        }
        Integer secondaryPrivateIpAddressCount = null;
        if (this.isOptionSet("secondary-private-ip-address-count")) {
            secondaryPrivateIpAddressCount = Integer.parseInt(this.getOptionValue("secondary-private-ip-address-count"));
        }
        if (null != secondaryPrivateIpAddressCount && null != privateIpAddresses) {
            throw new InvalidArgumentCombination("Specify either a secondary private IP address count or a list of secondary private IP addresses, not both.");
        }
        if ((null != secondaryPrivateIpAddressCount || null != privateIpAddresses) && null == subnetId) {
            throw new InvalidArgumentCombination("If you specify either a secondary private IP address count or a list of secondary private IP addresses, you must specify a subnet ID.");
        }
        if (null != primaryPrivateIpAddress && null == subnetId) {
            throw new InvalidArgumentCombination("If you specify a private IP address you must specify a subnet ID.");
        }
        if ((null != primaryPrivateIpAddress || null != secondaryPrivateIpAddressCount || null != privateIpAddresses) && null != subnetId) {
            if (attachments == null) {
                attachments = new ArrayList<NetworkInterfaceAttachmentRequestDescription>();
            }
            NetworkInterfaceAttachmentRequestDescription netDescription = new NetworkInterfaceAttachmentRequestDescription(null, Integer.valueOf(0), subnetId, null, primaryPrivateIpAddress, null, null, privateIpAddresses, secondaryPrivateIpAddressCount);
            subnetId = null;
            primaryPrivateIpAddress = null;
            attachments.add(netDescription);
        }
        IamInstanceProfileRequestDescription instanceProfile = null == (instanceProfileName = this.getOptionValue("iam-profile")) ? null : (instanceProfileName.startsWith("arn:") ? new IamInstanceProfileRequestDescription(instanceProfileName, null) : new IamInstanceProfileRequestDescription(null, instanceProfileName));
        RequestResultPair rsp = jec2.runInstances(imageId, range[0], range[1], groupIds, props, keyId, userData, addressing, instanceType, placement, kernel, ramdisk, blockDeviceMapping, Boolean.valueOf(monitoring), subnetId, Boolean.valueOf(disableApiTermination), instanceInitiatedShutdownBehavior, licensePool, primaryPrivateIpAddress, attachments, Boolean.valueOf(ebsOptimized), instanceProfile, clientToken);
        out.output(System.out, (ReservationDescription)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected List<BlockDeviceMappingDescription> getBlockDeviceMapping(String[] blockDeviceOptions) {
        ArrayList<BlockDeviceMappingDescription> blockDevices = new ArrayList<BlockDeviceMappingDescription>();
        if (blockDeviceOptions == null || blockDeviceOptions.length == 0) {
            return blockDevices;
        }
        for (String blockDeviceOption : blockDeviceOptions) {
            try {
                blockDevices.add(BlockDeviceMappingDescription.valueOf((String)blockDeviceOption));
            }
            catch (Exception e) {
                throw new InvalidArgument("block-device-mapping", blockDeviceOption);
            }
        }
        return blockDevices;
    }

    public String getUserData(String str) {
        String base64 = new BASE64Encoder().encodeBuffer(str.getBytes());
        return base64.replaceAll("\\s", "");
    }

    public static void main(String[] args) {
        new RunInstances(args).invoke();
    }
}

