/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        if (describeSnapshotsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSnapshotsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2012-07-20");
        List<String> snapshotIdsList = describeSnapshotsRequest.getSnapshotIds();
        int snapshotIdsListIndex = 1;
        for (String snapshotIdsListValue : snapshotIdsList) {
            if (snapshotIdsListValue != null) {
                request.addParameter("SnapshotId." + snapshotIdsListIndex, StringUtils.fromString((String)snapshotIdsListValue));
            }
            ++snapshotIdsListIndex;
        }
        List<String> ownerIdsList = describeSnapshotsRequest.getOwnerIds();
        int ownerIdsListIndex = 1;
        for (String ownerIdsListValue : ownerIdsList) {
            if (ownerIdsListValue != null) {
                request.addParameter("Owner." + ownerIdsListIndex, StringUtils.fromString((String)ownerIdsListValue));
            }
            ++ownerIdsListIndex;
        }
        List<String> restorableByUserIdsList = describeSnapshotsRequest.getRestorableByUserIds();
        int restorableByUserIdsListIndex = 1;
        for (String restorableByUserIdsListValue : restorableByUserIdsList) {
            if (restorableByUserIdsListValue != null) {
                request.addParameter("RestorableBy." + restorableByUserIdsListIndex, StringUtils.fromString((String)restorableByUserIdsListValue));
            }
            ++restorableByUserIdsListIndex;
        }
        List<Filter> filtersList = describeSnapshotsRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

