/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ftp.client;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.internal.ftp.FTPException;
import org.eclipse.team.internal.ftp.FTPPlugin;

/**
 * Exception class for fatal communications or protocol errors thrown
 * as a result of physical I/O errors or deviations from the known protocol.
 */
public class FTPCommunicationException extends FTPException {
	public FTPCommunicationException(String message, IOException e) {
		super(new Status(IStatus.ERROR, FTPPlugin.ID, IO_FAILED, message, e));
	}
	public FTPCommunicationException(String message, int status) {
		super(new Status(IStatus.ERROR, FTPPlugin.ID, status, message, null));
	}
}
