/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ftp.client;

import java.net.URL;

public class FTPProxyLocation {
	public static final int DEFAULT_PORT = 8080;
	private String hostname;
	private int port;
	private String username;
	private String password;
	
	/**
	 * Creates a new FTP proxy location.
	 * 
	 * @param hostname the hostname or dotted IP address
	 * @param port the port to connect to or DEFAULT_PORT
	 * @param username the user name for authentication
	 * @param password the password for authentication
	 */
	public FTPProxyLocation(String hostname, int port, String username, String password) {
		this.hostname = hostname;
		this.port = port;
		this.username = username;
		this.password = password;
	}
	
	/**
	 * Creates a new FTP location.
	 * 
	 * @param url URL which provides hostname and port
	 * @param username the user name for authentication
	 * @param password the password for authentication
	 * @param usePassive if true, uses passive mode
	 */
	public FTPProxyLocation(URL url, String username, String password) {
		this(url.getHost(), url.getPort() == -1 ? DEFAULT_PORT : url.getPort(), username, password);
	}
	
	public String getHostname() {
		return hostname;
	}
	
	public int getPort() {
		return port;
	}
	
	public String getUsername() {
		return username;
	}
	
	public String getPassword() {
		return password;
	}
	
	/*
	 * Returns a human-readable string for debugging purposes.
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer("ftp proxy: "); //$NON-NLS-1$
		buf.append(username);
		buf.append(':');
		buf.append(password);
		buf.append('@');
		buf.append(hostname);
		buf.append(':');
		buf.append(Integer.toString(port));
		return buf.toString();
	}
}
