/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.webdav.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;

import org.eclipse.webdav.http.client.IAuthenticator;

public class Authenticator implements IAuthenticator {
	
	private String username = null;
	private String password = null;
	private URL serverUrl = null;
	private String realm = null;
	private String scheme = null;
	private Map info = null;
	private URL resourceUrl = null;
	private String protectionSpace = null;

	public Authenticator() {
	}

	public Authenticator(String username, String password) {
		this.username = username;
		this.password = password;
	}

	public void addAuthenticationInfo(
		URL serverUrl,
		String realm,
		String scheme,
		Map info) {
		this.serverUrl = serverUrl;
		this.realm = realm;
		this.scheme = scheme;
		this.info = info;
	}

	public void addProtectionSpace(URL resourceUrl, String realm) {
		String file = resourceUrl.getFile();
		if (!file.endsWith("/")) {
			int lastSlashIndex = file.lastIndexOf('/');
			file = file.substring(0, lastSlashIndex + 1);
			try {
				resourceUrl = new URL(resourceUrl, file);
			} catch (MalformedURLException e) {
			}
		}

		this.resourceUrl = resourceUrl;
		this.protectionSpace = realm;
	}

	public Map getAuthenticationInfo(URL serverUrl, String realm, String scheme) {
		if (serverUrl.equals(this.serverUrl)
			&& realm.equals(this.realm)
			&& scheme.equals(this.scheme))
			return info;
		return null;
	}

	public String getProtectionSpace(URL resourceUrl) {
		if (this.resourceUrl != null
			&& resourceUrl.toString().startsWith(this.resourceUrl.toString()))
			return protectionSpace;
		return null;
	}

	public Map requestAuthenticationInfo(
		URL resourceUrl,
		String realm,
		String scheme) {
		String username = this.username;
		String password = this.password;

		if (username == null || password == null) {
			System.out.println();
			System.out.println("Request Authentication Info");
			System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~");
			System.out.println("Resource: " + resourceUrl);
			System.out.println("Realm: " + realm);
			System.out.println("Scheme: " + scheme);

			try {
				BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
				if (username == null) {
					System.out.print("Enter username -> ");
					username = reader.readLine();
				}
				if (password == null) {
					System.out.print("Enter password -> ");
					password = reader.readLine();
				}
			} catch (IOException e) {
				return null;
			}
		}

		if (username.length() == 0 || password.length() == 0)
			return null;

		Hashtable info = new Hashtable(2);
		info.put("username", username);
		info.put("password", password);

		return info;
	}
}
