/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ui.internal.versioncheck;

import java.text.MessageFormat;

import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

/**
 * Application to notify the user that the workspace version is different
 * than the running eclipse version, and to prompt whether to proceed or 
 * exit with no changes.
 */
public class VersionCheck implements IPlatformRunnable {

	public Object run(Object args) throws Exception {
		String title = VersionCheckPlugin.getResourceString("versionPrompt.title"); //$NON-NLS-1$
		String messageFmt = VersionCheckPlugin.getResourceString("versionPrompt.message"); //$NON-NLS-1$
		String message = MessageFormat.format(messageFmt, new Object[] { Platform.getLocation().toOSString() });
		Display display = new Display();
		Shell shell = new Shell(display);
		MessageBox mbox = new MessageBox(shell, SWT.OK | SWT.CANCEL | SWT.ICON_WARNING | SWT.APPLICATION_MODAL);
		mbox.setText(title);
		mbox.setMessage(message);
		int result = mbox.open();
		shell.dispose();
		display.close();
		return new Boolean(result == SWT.OK);
	}
}
