import warnings
warnings.simplefilter('ignore', FutureWarning)
import os
import apt
import apt_pkg
import aptsources
import aptsources.distro
from aptsources.sourceslist import SourcesList
from apt import SizeToStr
import subprocess
from subprocess import PIPE, Popen

import time
import sys
from sys import stderr, stdout

from PyQt4.QtCore import *
from PyQt4.QtGui import *

from Envy import packagemanager
from Envy import ui

class HeadersException(Exception):
    '''
    Raise if no headers can be found and installed
    '''
    pass

class QtFetchProgress(apt.FetchProgress, QThread):
    '''
    The only purpose of this class is update the "percent"
    attribute of the object passed to the constructor
    '''
    def __init__(self, parent=None, myobject=None, text=None):
        '''
        myobject is the UI class:
            * the class of the textual progress bar
            * the entire widget class for the GUIs which should have 2 methods:
                1) updateLabel(currentItems, totalItems)
                2) updateUi(percent)
        '''
        #apt.FetchProgress.__init__(self)
        super(QtFetchProgress, self).__init__()
        self.newObject = myobject
        self.isText = text
        self.percent = 0.0
        self.translation = ui.AbstractUI()
    
    def start(self):
        if self.isText:
            print >> stderr, '\nDowloading the packages...'
        #print >> stderr, 'Starting Fetch process'
    
    def stop(self):
        pass
    
    def done(self, *args):
        pass
    
    def update(self, percent):
        self.percent = percent
    
    def run(self):
        pass
    
    def updateStatus(self, uri, descr, shortDescr, status):
        message = '%s %d/%d...' % (self.translation.string_package_download, self.currentItems, self.totalItems)
        self.emit(SIGNAL("started(QString)"), message)
        
        
    def pulse(self):
        self.percent = ((self.currentBytes + self.currentItems)*100)/(self.totalBytes+self.totalItems)
        
            
        if self.percent < 0: self.percent = 0
        if self.percent > 100: self.percent = 100
        
        self.emit(SIGNAL("downloaded"), self.percent)
        
        return True


class QtInstallProgress(apt.InstallProgress, QThread):
    def __init__(self, myobject=None, text=None):
        #apt.InstallProgress.__init__(self)
        super(QtInstallProgress, self).__init__()
        self.translation = ui.AbstractUI()
        
    def startUpdate(self):
        pass
        #print "StartUpdate"
        
    def finishUpdate(self):
        self.emit(SIGNAL("complete(bool)"), 1)
        
    def statusChange(self, pkg, percent, status):
        if self.isText:
            print "\r%s: %s" % (pkg, status)
            print '\r'
#        self.newObject.percent = percent
        else:
            try:
                message = '%s %s: %s' % (self.translation.string_package_install, pkg, status)
            except AttributeError:
                message = '%s %s: %s' % ('Installing package', pkg, status)
            
            self.emit(SIGNAL("started(QString)"), message)
            self.emit(SIGNAL("downloaded"), percent)
    
    def run(self):
        pass
    
    def updateInterface(self):
        apt.InstallProgress.updateInterface(self)
        # usefull to e.g. redraw a GUI
        time.sleep(0.1)




class PkgManager(packagemanager.PkgManager):
    def __init__(self, widget, text=None):
        packagemanager.PkgManager.__init__(self, widget, text)
        self.initialise(widget)
        self.isText = text
        self.fetchProgress = QtFetchProgress()
        self.installProgress = QtInstallProgress()
    
    
    def install(self, packages, widget):
        self.initialise(widget)
        
        install = False
        
        for package in packages:
            try:
                pkg = self.cacheUi[package]
                pkg.markInstall()
                install = True
            except KeyError:
                pass
        
        if install:
            try:
                self.cacheUi.commit(self.fetchProgress(widget, self.isText), self.installProgress(widget, self.isText)) 
            except apt.cache.FetchCancelledException: 
                return False 
        #return True
    
    def reinstall(self, packages, widget):
        self.initialise(widget)
        install = False
        
        for package in packages:
            try:
                pkg = self.cacheUi[package]
                self.cacheUi._depcache.SetReInstall(pkg._pkg, True)
                
                install = True
            except (KeyError, SystemError):
                '''
                NOTE: SystemError = the specific package version can't be found
                in the archive
                '''
                pass
        
        if install:
            try:
                self.cacheUi.commit(QtFetchProgress(widget, self.isText), QtInstallProgress(widget, self.isText))
            except apt.cache.FetchCancelledException: 
                return False 
        #return True
    
    def uninstall(self, packages, widget):
        self.initialise(widget)
        uninstall = False
        
        for package in packages:
            try:
                pkg = self.cacheUi[package]
                if pkg.isInstalled:
                    pkg.markDelete()
                    uninstall = True
            except KeyError:
                pass
        if uninstall:
            try:
                self.cacheUi.commit(None, QtInstallProgress(widget, self.isText))
            except apt.cache.FetchCancelledException: 
                return False 
        #return True
    
if __name__ == '__main__':
    a = PkgManager()
    b = a.getPkgDeps('nvidia-glx-173')#'nvidia-glx-173')
    deps = b[0]
    #print deps
    dependencies = []
    for dep in deps:
        #print ",".join(["%s (%s) (%s) (%s)" % (o.name,o.version,o.relation, o.preDepend) for o in dep.or_dependencies])
        dependencies.append([o.name for o in dep.or_dependencies][0])
    
    try:
        mesa = dependencies.index('libgl1-mesa')
        dependencies[mesa] = 'libgl1-mesa-glx'
    except IndexError:
        pass
    
    print dependencies
    for x in dependencies:
        if x == 'libgl1-mesa': x = 'libgl1-mesa-glx'
        print x, ':\n', a.getPkgInfo(x)
        print a.getUrl(x)

