#!/usr/bin/env python

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from Envy import ui
import ui_envyngterm
import sys
import codecs
import qterrordialog
import os

CODEC = "UTF-8"


class EnvyTerm(QDialog, ui_envyngterm.Ui_EnvyNGTerm):
    '''
    Execute a command
    Write a logfile
    Show the output inside of a textEdit
    Show the Error inside of a Dialog (since the process should stop)
    
    USAGE: 
    mycommand = QString('your_command')
    form = EnvyTerm(mycommand, 'logged.txt')
    form.startCommand()
    form.show()
    '''
    def __init__(self, command, dir, logfile, restart, parent=None):
        super(EnvyTerm, self).__init__(parent)
        self.setupUi(self)
        
        self.mustrestart = restart
        
        '''
        Translations
        '''
        self.translation = ui.AbstractUI()
        self.close_button.setText(self.translation.string_cancel_button)
        
        self.setWindowIcon(QIcon('/usr/share/envyng-qt/pixmaps/envyng.png'))
        self.setWindowTitle(QString('EnvyNG'))
        
        self.error = False
        self.commandlist = QStringList()
        os.chdir(dir)
        #print 'My Directory is', os.getcwd()
        self.mycommand = QString(command)
        self.filename = QString(logfile)
        self.myProcess = QProcess()
        self.connect(self.myProcess, SIGNAL("readyReadStandardOutput()"), self.readOutput)
        self.connect(self.myProcess, SIGNAL("readyReadStandardError()"), self.readErrors)
        self.connect(self.myProcess, SIGNAL("finished(int)"), self.endCommand)
        
#        self.connect(self.textEdit, SIGNAL('cursorPositionChanged'), self.writeFile)
#        self.connect(self.myProcess, SIGNAL("readyReadStandardError()"), self.readErrors)
        #self.myProcess.start(self.program, self.arguments)
        #self.connect(self.applyButton,  SIGNAL('clicked()'), self.startCommand)
    
    def startCommand(self):
        fileb = open(self.filename,  'w')
        fileb.write('')
        fileb.close()
        self.file = open(self.filename,  'a')
        self.textEdit.setFocus()
        self.myProcess.start(self.mycommand)

    
    def stopCommand(self):
        #self.resetButtons()
        self.myProcess.terminate()
        QTimer.singleShot(5000, self.myProcess, SLOT("kill()"))
    

    def readOutput(self):
        #print 'Output'#, unicode(self.myProcess.readAllStandardOutput())
        self.textEdit.append(QString(self.myProcess.readAllStandardOutput()))
        cursor = QTextCursor()
        cursor = self.textEdit.textCursor()
        cur_line_text = QString()
        cur_line_text = cursor.block().text().trimmed()
        self.fileSave()

        '''
        QTextCursor cursor      = fontfileEdit->textCursor();
        
        // Current line text
        QString cur_line_text   = cursor.block().text().trimmed();
        
        // Current line
        int     cur_line_number = cursor.blockNumber();
        
        // Current column
        int     cur_line_column = cursor.columnNumber();
        
        '''

    def readErrors(self):
        #print 'Error!!!'
        errortxt = unicode(self.myProcess.readAllStandardError())
        #self.textEdit.append(QString(error))
        self.textEdit.append(QString(self.myProcess.readAllStandardError()))
        self.fileSave()
        
        self.hide()
        
        self.error = True
        self.errormessage = errortxt
        #print error
        #self.endCommand()
        #self.stopCommand()
        

    def fileSave(self):
        if self.filename.startsWith("Unnamed"):
            return self.fileSaveAs()
        fh = None
        try:
            fh = QFile(self.filename)
            if not fh.open(QIODevice.WriteOnly):
                raise IOError, unicode(fh.errorString())
            stream = QTextStream(fh)
            stream.setCodec("UTF-8")
            stream << self.textEdit.toPlainText()
            #self.textEdit.document().setModified(False)
        except (IOError, OSError), e:
            #QMessageBox.warning(self, "EnvyNG -- Save Error",
                    #"Failed to save %s: %s" % (self.filename, e))
            QMessageBox.warning(self, self.translation.string_directory_error_title,
                    self.translation.string_directory_error_msg)
                    
                    
        finally:
            if fh is not None:
                fh.close()
        return True


    def endCommand(self):
        self.hide()
        self.file.close()#just in case...
        if self.error == True:
            dialog = qterrordialog.ErrorDlg(self.translation.string_qt_show_error, self.errormessage)
            dialog.show()
            dialog.exec_()
        else:
            if self.mustrestart == 0:
                response = self.translation.string_ok_button
                # buttons texts
                OK = self.translation.string_ok_button
        
                dialog = QMessageBox(self)
                dialog.setText(self.translation.string_operation_complete)
                dialog.setWindowTitle('EnvyNG')
                dialog.setIcon(QMessageBox.Information)
                dialog.addButton(OK, QMessageBox.AcceptRole)
                dialog.exec_()
                response = dialog.clickedButton().text()
                if response == self.translation.string_ok_button:
                    dialog.hide()
            else:
                self.restartDialog()
        
        self.error = False
    
    
    def systemRestart(self):
        os.system('sudo reboot')
        sys.exit()
        
    def restartDialog(self):
        response = False
        # buttons texts
        YES = self.translation.string_yes
        NO = self.translation.string_no

        message = QMessageBox(self)
        message.setText(self.translation.string_operation_complete_restart)
        message.setWindowTitle('EnvyNG')
        message.setIcon(QMessageBox.Question)
        message.addButton(YES, QMessageBox.AcceptRole)
        message.addButton(NO, QMessageBox.RejectRole)
        #message.setDetailedText('(EnvyNG won\'t work without them)')
        message.exec_()
        response = message.clickedButton().text()
        if response == YES:
            self.systemRestart()
            #print response
    
        #print 'Finished!!!'

    @pyqtSignature("")
    def on_close_button_clicked(self):
        self.stopCommand()
        

if __name__ == "__main__":
    app = QApplication(sys.argv)
    mycommand = QString('sudo python pulse.py nvidia latest 1 1 /home/alberto/pippo')
    form = EnvyTerm(mycommand, '/usr/share/envy', '/var/log/envy-installer.log', 0)
    
    form.show()
    form.startCommand()
    app.exec_()
    

