/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class TextGenerator
extends ServiceableGenerator
implements CacheableProcessingComponent {
    public static final String URI = "http://chaperon.sourceforge.net/schema/text/1.0";
    private Source inputSource = null;
    private String encoding = null;

    public void recycle() {
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
        }
        this.inputSource = null;
        this.encoding = null;
        super.recycle();
    }

    public void setup(SourceResolver resolver, Map objectmodel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectmodel, src, parameters);
        try {
            this.encoding = parameters.getParameter("encoding", null);
            this.inputSource = resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw new ProcessingException("Error during resolving of '" + src + "'.", (Throwable)se);
        }
    }

    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.inputSource.getValidity();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String line;
        InputStreamReader in = null;
        try {
            if (this.inputSource.getInputStream() == null) {
                throw new ProcessingException("Source '" + this.inputSource.getURI() + "' not found");
            }
            in = this.encoding != null ? new InputStreamReader(this.inputSource.getInputStream(), this.encoding) : new InputStreamReader(this.inputSource.getInputStream());
        }
        catch (SourceException se) {
            throw new ProcessingException("Error during resolving of '" + this.source + "'.", (Throwable)se);
        }
        LocatorImpl locator = new LocatorImpl();
        locator.setSystemId(this.inputSource.getURI());
        locator.setLineNumber(1);
        locator.setColumnNumber(1);
        this.contentHandler.setDocumentLocator(locator);
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("", URI);
        AttributesImpl atts = new AttributesImpl();
        this.contentHandler.startElement(URI, "text", "text", atts);
        LineNumberReader reader = new LineNumberReader(in);
        String newline = null;
        String separator = System.getProperty("line.separator");
        while ((line = newline == null ? reader.readLine() : newline) != null) {
            newline = reader.readLine();
            line = newline != null ? line + separator : line;
            locator.setLineNumber(reader.getLineNumber());
            locator.setColumnNumber(1);
            this.contentHandler.characters(line.toCharArray(), 0, line.length());
            if (newline != null) continue;
        }
        this.contentHandler.endElement(URI, "text", "text");
        this.contentHandler.endPrefixMapping("");
        this.contentHandler.endDocument();
    }
}

