/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import net.sourceforge.chaperon.adapter.avalon.LexiconFactory;
import net.sourceforge.chaperon.adapter.sax.LexicalHandlerAdapter;
import net.sourceforge.chaperon.adapter.sax.LexicalProcessorAdapter;
import net.sourceforge.chaperon.build.LexicalAutomatonBuilder;
import net.sourceforge.chaperon.model.lexicon.Lexicon;
import net.sourceforge.chaperon.process.LexicalAutomaton;
import net.sourceforge.chaperon.process.LexicalHandler;
import net.sourceforge.chaperon.process.LexicalProcessor;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.store.Store;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LexicalTransformer
extends LexicalProcessorAdapter
implements Transformer,
LogEnabled,
Composable,
Recyclable,
Disposable,
Parameterizable,
CacheableProcessingComponent {
    private String lexicon;
    private Source lexiconSource;
    private Logger logger;
    private ComponentManager manager;
    private SourceResolver resolver;
    private LexicalAutomaton automaton = null;
    private LexicalHandlerAdapter adapter = new LexicalHandlerAdapter(true);
    private boolean recovery = false;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.recovery = parameters.getParameterAsBoolean("recovery", false);
    }

    public void setConsumer(XMLConsumer consumer) {
        this.setContentHandler((ContentHandler)consumer);
        this.setLexicalHandler((org.xml.sax.ext.LexicalHandler)consumer);
        this.adapter.setContentHandler((ContentHandler)consumer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setup(SourceResolver resolver, Map objectmodel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
        Store store = null;
        try {
            try {
                this.lexicon = src;
                this.lexiconSource = resolver.resolveURI(this.lexicon);
                store = (Store)this.manager.lookup(Store.TRANSIENT_STORE);
                LexicalAutomatonEntry entry = (LexicalAutomatonEntry)store.get((Object)this.lexiconSource.getURI());
                if (entry == null || entry.getValidity() == null || entry.getValidity().isValid(this.lexiconSource.getValidity()) <= 0) {
                    this.logger.info("(Re)building the automaton from '" + this.lexiconSource.getURI() + "'");
                    SAXConfigurationHandler confighandler = new SAXConfigurationHandler();
                    if (this.lexiconSource.getInputStream() == null) {
                        throw new ProcessingException("Source '" + this.lexiconSource.getURI() + "' not found");
                    }
                    SourceUtil.toSAX((ComponentManager)this.manager, (Source)this.lexiconSource, null, (ContentHandler)confighandler);
                    Configuration config = confighandler.getConfiguration();
                    Lexicon lexicon = LexiconFactory.createLexicon((Configuration)config);
                    LexicalAutomatonBuilder builder = new LexicalAutomatonBuilder(lexicon, this.logger);
                    this.automaton = builder.getLexicalAutomaton();
                    this.logger.info("Store automaton into store for '" + this.lexiconSource.getURI() + "'");
                    store.store((Object)this.lexiconSource.getURI(), (Object)new LexicalAutomatonEntry(this.automaton, this.lexiconSource.getValidity()));
                } else {
                    this.logger.info("Getting automaton from store for '" + this.lexiconSource.getURI() + "'");
                    this.automaton = entry.getLexicalAutomaton();
                }
                if (this.getLexicalProcessor() == null) {
                    LexicalProcessor processor = new LexicalProcessor();
                    processor.setLexicalHandler((LexicalHandler)this.adapter);
                    processor.setLogger(this.logger);
                    processor.setRecovery(this.recovery);
                    this.setLexicalProcessor(processor);
                }
                this.getLexicalProcessor().setLexicalAutomaton(this.automaton);
            }
            catch (ConfigurationException confige) {
                throw new ProcessingException("Error during retrieving the lexicon", (Throwable)confige);
            }
            catch (SourceException se) {
                throw new ProcessingException("Error during resolving of '" + src + "'.", (Throwable)se);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Could not lookup for component", (Throwable)ce);
            }
            Object var12_14 = null;
            if (store == null) return;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (store == null) throw throwable;
            this.manager.release(store);
            throw throwable;
        }
        this.manager.release((Component)store);
    }

    public Serializable getKey() {
        return this.lexiconSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.lexiconSource.getValidity();
    }

    public void recycle() {
        if (this.resolver != null && this.lexiconSource != null) {
            this.resolver.release(this.lexiconSource);
            this.lexiconSource = null;
        }
        this.automaton = null;
    }

    public void dispose() {
        if (this.resolver != null && this.lexiconSource != null) {
            this.resolver.release(this.lexiconSource);
            this.lexiconSource = null;
        }
        this.manager = null;
    }

    public class LexicalAutomatonEntry
    implements Serializable {
        private SourceValidity validity = null;
        private LexicalAutomaton automaton = null;

        public LexicalAutomatonEntry(LexicalAutomaton automaton, SourceValidity validity) {
            this.automaton = automaton;
            this.validity = validity;
        }

        public SourceValidity getValidity() {
            return this.validity;
        }

        public LexicalAutomaton getLexicalAutomaton() {
            return this.automaton;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.validity);
            out.writeObject(this.automaton);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.validity = (SourceValidity)in.readObject();
            this.automaton = (LexicalAutomaton)in.readObject();
        }
    }
}

