/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml;

import java.io.IOException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.EntityResolver;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultEntityResolver
extends AbstractLogEnabled
implements EntityResolver,
Serviceable,
Parameterizable,
ThreadSafe,
Disposable,
Component {
    protected CatalogManager catalogManager = new CatalogManager();
    protected CatalogResolver catalogResolver = new CatalogResolver(this.catalogManager);
    protected ServiceManager manager;
    protected SourceResolver resolver;

    public void parameterize(Parameters params) throws ParameterException {
        String catalogFile;
        String verbosity = params.getParameter("verbosity", null);
        if (null != verbosity) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Setting Catalog resolver verbosity level to " + verbosity);
            }
            int verbosityLevel = 0;
            try {
                verbosityLevel = Integer.parseInt(verbosity);
                this.catalogManager.setVerbosity(verbosityLevel);
            }
            catch (NumberFormatException ce1) {
                this.getLogger().warn("Trouble setting Catalog verbosity", (Throwable)ce1);
            }
        }
        if (null == (catalogFile = params.getParameter("catalog", this.defaultCatalog()))) {
            this.getLogger().warn("No default catalog defined.");
        } else {
            this.parseCatalog(catalogFile);
        }
        String localCatalogFile = params.getParameter("local-catalog", null);
        if (null != localCatalogFile) {
            this.parseCatalog(localCatalogFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseCatalog(String file) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Additional Catalog is " + file);
        }
        Source source = null;
        try {
            try {
                source = this.resolver.resolveURI(file);
                this.catalogResolver.getCatalog().parseCatalog(source.getURI());
            }
            catch (Exception e) {
                this.getLogger().warn("Could not get Catalog file. Trying again: " + file, (Throwable)e);
                if (null != source) {
                    try {
                        String mimeType = source.getMimeType();
                        if (null == mimeType) {
                            mimeType = " text/plain";
                        }
                        this.catalogResolver.getCatalog().parseCatalog(mimeType, source.getInputStream());
                    }
                    catch (Exception ex) {
                        this.getLogger().warn("Could not get Catalog file: " + file, (Throwable)ex);
                    }
                }
                Object var6_4 = null;
                this.resolver.release(source);
                return;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.resolver.release(source);
            throw throwable;
        }
        this.resolver.release(source);
    }

    protected String defaultCatalog() {
        return null;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource altInputSource = this.catalogResolver.resolveEntity(publicId, systemId);
        if (altInputSource != null && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolved catalog entity: " + publicId + " " + altInputSource.getSystemId());
        }
        return altInputSource;
    }

    public void dispose() {
        if (null != this.resolver) {
            this.manager.release((Object)this.resolver);
        }
    }
}

