/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpServer;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.Code;
import org.mortbay.util.Log;
import org.mortbay.util.Resource;
import org.mortbay.xml.XmlConfiguration;

public class Server
extends HttpServer {
    private String _configuration;
    private String _rootWebApp;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    public Server() {
    }

    public Server(String configuration) throws IOException {
        this(Resource.newResource(configuration).getURL());
    }

    public Server(Resource configuration) throws IOException {
        this(configuration.getURL());
    }

    public Server(URL configuration) throws IOException {
        this._configuration = configuration.toString();
        try {
            XmlConfiguration config = new XmlConfiguration(configuration);
            config.configure(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Code.warning(e);
            throw new IOException("Jetty configuration problem: " + e);
        }
    }

    public String getRootWebApp() {
        return this._rootWebApp;
    }

    public void setRootWebApp(String rootWebApp) {
        this._rootWebApp = rootWebApp;
    }

    public void configure(String configuration) throws IOException {
        URL url = Resource.newResource(configuration).getURL();
        if (this._configuration != null && this._configuration.equals(url.toString())) {
            return;
        }
        if (this._configuration != null) {
            throw new IllegalStateException("Already configured with " + this._configuration);
        }
        try {
            XmlConfiguration config = new XmlConfiguration(url);
            this._configuration = url.toString();
            config.configure(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Code.warning(e);
            throw new IOException("Jetty configuration problem: " + e);
        }
    }

    public String getConfiguration() {
        return this._configuration;
    }

    protected HttpContext newHttpContext() {
        return new ServletHttpContext();
    }

    public WebApplicationContext addWebApplication(String contextPathSpec, String webApp) throws IOException {
        return this.addWebApplication(null, contextPathSpec, webApp);
    }

    public WebApplicationContext addWebApplication(String virtualHost, String contextPathSpec, String webApp) throws IOException {
        WebApplicationContext appContext = new WebApplicationContext(webApp);
        appContext.setContextPath(contextPathSpec);
        this.addContext(virtualHost, appContext);
        Code.debug("Web Application ", appContext, " added");
        return appContext;
    }

    public WebApplicationContext[] addWebApplications(String webapps) throws IOException {
        return this.addWebApplications(null, webapps, null, false);
    }

    public WebApplicationContext[] addWebApplications(String host, String webapps) throws IOException {
        return this.addWebApplications(host, webapps, null, false);
    }

    public WebApplicationContext[] addWebApplications(String host, String webapps, boolean extract) throws IOException {
        return this.addWebApplications(host, webapps, null, extract);
    }

    public WebApplicationContext[] addWebApplications(String host, String webapps, String defaults, boolean extract) throws IOException {
        ArrayList<WebApplicationContext> wacs = new ArrayList<WebApplicationContext>();
        Resource r = Resource.newResource(webapps);
        if (!r.exists()) {
            throw new IllegalArgumentException("No such webapps resource " + r);
        }
        if (!r.isDirectory()) {
            throw new IllegalArgumentException("Not directory webapps resource " + r);
        }
        String[] files = r.list();
        int f = 0;
        while (files != null && f < files.length) {
            String context = files[f];
            if (!(context.equalsIgnoreCase("CVS/") || context.equalsIgnoreCase("CVS") || context.startsWith("."))) {
                Resource unpacked;
                String app = r.addPath(r.encode(files[f])).toString();
                if (!context.toLowerCase().endsWith(".war") && !context.toLowerCase().endsWith(".jar") || (unpacked = r.addPath(context = context.substring(0, context.length() - 4))) == null || !unpacked.exists() || !unpacked.isDirectory()) {
                    context = this._rootWebApp != null && (context.equals(this._rootWebApp) || context.equals(this._rootWebApp + "/")) ? "/" : "/" + context;
                    WebApplicationContext wac = this.addWebApplication(host, context, app);
                    wac.setExtractWAR(extract);
                    if (defaults != null) {
                        if (defaults.length() == 0) {
                            wac.setDefaultsDescriptor(null);
                        } else {
                            wac.setDefaultsDescriptor(defaults);
                        }
                    }
                    wacs.add(wac);
                }
            }
            ++f;
        }
        return wacs.toArray(new WebApplicationContext[wacs.size()]);
    }

    public WebApplicationContext addWebApplication(String contextPathSpec, String webApp, String defaults, boolean extractWar) throws IOException {
        return this.addWebApplication(null, contextPathSpec, webApp, defaults, extractWar);
    }

    public WebApplicationContext addWebApplication(String virtualHost, String contextPathSpec, String webApp, String defaults, boolean extractWar) throws IOException {
        Log.warning("DEPRECATED: use addWebApplicaton(host,path,webapp)");
        WebApplicationContext appContext = this.addWebApplication(virtualHost, contextPathSpec, webApp);
        appContext.setDefaultsDescriptor(defaults);
        appContext.setExtractWAR(extractWar);
        return appContext;
    }

    public static void main(String[] arg) {
        String[] dftConfig = new String[]{"etc/jetty.xml"};
        if (arg.length == 0) {
            Log.event("Using default configuration: etc/jetty.xml");
            arg = dftConfig;
        }
        final Server[] servers = new Server[arg.length];
        int i = 0;
        while (i < arg.length) {
            try {
                servers[i] = new Server(arg[i]);
                servers[i].start();
            }
            catch (Exception e) {
                Code.warning(e);
            }
            ++i;
        }
        if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK")) {
            try {
                Method shutdownHook = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Server.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = Server.class$("java.lang.Thread")) : class$java$lang$Thread);
                Thread hook = new Thread(){

                    public void run() {
                        this.setName("Shutdown");
                        Log.event("Shutdown hook executing");
                        int i = 0;
                        while (i < servers.length) {
                            if (servers[i] != null) {
                                try {
                                    servers[i].stop();
                                }
                                catch (Exception e) {
                                    Code.warning(e);
                                }
                            }
                            ++i;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            Code.warning(e);
                        }
                    }
                };
                shutdownHook.invoke((Object)Runtime.getRuntime(), hook);
            }
            catch (Exception e) {
                Code.debug("No shutdown hook in JVM ", e);
            }
        }
        int i2 = 0;
        while (i2 < arg.length) {
            try {
                servers[i2].join();
            }
            catch (Exception e) {
                Code.ignore(e);
            }
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

