/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.ast;

import java.util.Vector;
import net.sourceforge.chaperon.process.LexicalHandler;
import net.sourceforge.chaperon.process.Locator;

public class LexicalAdapter
implements LexicalHandler {
    private Vector symbols = new Vector();
    private Vector texts = new Vector();
    private Vector locations = new Vector();
    private Locator locator = null;

    public int getLexemeCount() {
        return this.symbols.size();
    }

    public String getLexemeLocation(int index) {
        return (String)this.locations.elementAt(index);
    }

    public String getLexemeSymbol(int index) {
        return (String)this.symbols.elementAt(index);
    }

    public String getLexemeText(int index) {
        return (String)this.texts.elementAt(index);
    }

    public void handleEndDocument() throws Exception {
    }

    public void handleError(String symbol, String text, String message) throws Exception {
        if (this.locator != null) {
            throw new IllegalStateException(String.valueOf(message) + "[" + this.locator.getURI() + ":" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber() + "]");
        }
        throw new IllegalStateException(message);
    }

    public void handleLexeme(String symbol, String text) throws Exception {
        this.symbols.addElement(symbol);
        this.texts.addElement(text);
        if (this.locator != null) {
            this.locations.addElement(String.valueOf(this.locator.getURI()) + ":" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber());
        } else {
            this.locations.addElement("unknown");
        }
    }

    public void handleLocator(Locator locator) {
        this.locator = locator;
    }

    public void handleStartDocument() throws Exception {
        this.symbols.clear();
        this.texts.clear();
    }
}

