/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.sax;

import java.util.Stack;
import net.sourceforge.chaperon.model.pattern.Alternation;
import net.sourceforge.chaperon.model.pattern.BeginOfLine;
import net.sourceforge.chaperon.model.pattern.CharacterClass;
import net.sourceforge.chaperon.model.pattern.CharacterClassElement;
import net.sourceforge.chaperon.model.pattern.CharacterInterval;
import net.sourceforge.chaperon.model.pattern.CharacterSet;
import net.sourceforge.chaperon.model.pattern.CharacterString;
import net.sourceforge.chaperon.model.pattern.Concatenation;
import net.sourceforge.chaperon.model.pattern.EndOfLine;
import net.sourceforge.chaperon.model.pattern.Pattern;
import net.sourceforge.chaperon.model.pattern.PatternGroup;
import net.sourceforge.chaperon.model.pattern.UniversalCharacter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PatternFactory
extends DefaultHandler {
    public static final String URI = "http://chaperon.sourceforge.net/schema/pattern/1.0";
    public static final String ALTERNATION_ELEMENT = "alt";
    public static final String BEGINOFLINE_ELEMENT = "bol";
    public static final String CHARACTERCLASS_ELEMENT = "cclass";
    public static final String EXCLUSIVE_ATTRIBUTE = "exclusive";
    public static final String CHARACTERINTERVAL_ELEMENT = "cinterval";
    public static final String CHARACTERINTERVAL_MIN_ATTRIBUTE = "min";
    public static final String CHARACTERINTERVAL_MAX_ATTRIBUTE = "max";
    public static final String CHARACTERSTRING_ELEMENT = "cstring";
    public static final String CHARACTERSTRING_SEQUENCE_ATTRIBUTE = "content";
    public static final String CHARACTERSET_ELEMENT = "cset";
    public static final String CHARACTERSET_CHARACTERS_ATTRIBUTE = "content";
    public static final String CONCATENATION_ELEMENT = "concat";
    public static final String GROUP_ELEMENT = "group";
    public static final String UNIVERSALCHARACTER_ELEMENT = "dot";
    public static final String ENDOFLINE_ELEMENT = "eol";
    public static final String MINOCCURS_ATTRIBUTE = "minOccurs";
    public static final String MAXOCCURS_ATTRIBUTE = "maxOccurs";
    private Pattern pattern;
    private Stack stack;

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (namespaceURI.equals(URI)) {
                if (localName.equals(ALTERNATION_ELEMENT) || localName.equals(CONCATENATION_ELEMENT) || localName.equals(CHARACTERSTRING_ELEMENT) || localName.equals(CHARACTERCLASS_ELEMENT) || localName.equals(GROUP_ELEMENT) || localName.equals(UNIVERSALCHARACTER_ELEMENT) || localName.equals(BEGINOFLINE_ELEMENT) || localName.equals(ENDOFLINE_ELEMENT)) {
                    Pattern patternelement = (Pattern)this.stack.pop();
                    if (this.stack.empty()) {
                        this.pattern = patternelement;
                    } else if (this.stack.peek() instanceof Alternation) {
                        Alternation alternation = (Alternation)this.stack.peek();
                        alternation.addPattern(patternelement);
                    } else if (this.stack.peek() instanceof Concatenation) {
                        Concatenation concatenation = (Concatenation)this.stack.peek();
                        concatenation.addPattern(patternelement);
                    } else if (this.stack.peek() instanceof PatternGroup) {
                        PatternGroup group = (PatternGroup)this.stack.peek();
                        group.addPattern(patternelement);
                    }
                } else if (localName.equals(CHARACTERSET_ELEMENT) || localName.equals(CHARACTERINTERVAL_ELEMENT)) {
                    CharacterClassElement characterclasselement = (CharacterClassElement)this.stack.pop();
                    CharacterClass characterclass = (CharacterClass)this.stack.peek();
                    characterclass.addCharacterClassElement(characterclasselement);
                } else {
                    System.out.println("name=" + localName + " ns=" + namespaceURI + " qname=" + qName + " would not process");
                }
            } else {
                System.out.println("name=" + localName + " ns=" + namespaceURI + " qname=" + qName + " would not process");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean getExclusiveFromAttributes(Attributes atts) {
        String attribute = atts.getValue(EXCLUSIVE_ATTRIBUTE);
        if (attribute != null && attribute.length() > 0) {
            boolean value = false;
            try {
                value = Boolean.valueOf(attribute);
                return value;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private int getMaxOccursFromAttributes(Attributes atts) {
        int maxOccurs = 1;
        String attribute = atts.getValue(MAXOCCURS_ATTRIBUTE);
        if (attribute != null && attribute.length() > 0) {
            if (attribute.equals("*")) {
                maxOccurs = Integer.MAX_VALUE;
            } else {
                try {
                    maxOccurs = new Integer(attribute);
                }
                catch (NumberFormatException numberFormatException) {
                    maxOccurs = 1;
                }
                if (maxOccurs < 1) {
                    maxOccurs = 1;
                }
            }
        }
        return maxOccurs;
    }

    private int getMinOccursFromAttributes(Attributes atts) {
        int minOccurs = 1;
        String attribute = atts.getValue(MINOCCURS_ATTRIBUTE);
        if (attribute != null && attribute.length() > 0) {
            try {
                minOccurs = new Integer(attribute);
            }
            catch (NumberFormatException numberFormatException) {
                minOccurs = 1;
            }
            if (minOccurs < 0) {
                minOccurs = 0;
            }
        }
        return minOccurs;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void startDocument() {
        this.stack = new Stack();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (namespaceURI.equals(URI)) {
                if (localName.equals(ALTERNATION_ELEMENT)) {
                    Alternation alternation = new Alternation();
                    alternation.setMinOccurs(this.getMinOccursFromAttributes(atts));
                    alternation.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
                    this.stack.push(alternation);
                } else if (localName.equals(CONCATENATION_ELEMENT)) {
                    Concatenation concatenation = new Concatenation();
                    concatenation.setMinOccurs(this.getMinOccursFromAttributes(atts));
                    concatenation.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
                    this.stack.push(concatenation);
                } else if (localName.equals(CHARACTERSTRING_ELEMENT)) {
                    CharacterString characterstring = new CharacterString();
                    characterstring.setMinOccurs(this.getMinOccursFromAttributes(atts));
                    characterstring.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
                    characterstring.setString(atts.getValue("content"));
                    this.stack.push(characterstring);
                } else if (localName.equals(GROUP_ELEMENT)) {
                    PatternGroup group = new PatternGroup();
                    group.setMinOccurs(this.getMinOccursFromAttributes(atts));
                    group.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
                    this.stack.push(group);
                } else if (localName.equals(UNIVERSALCHARACTER_ELEMENT)) {
                    UniversalCharacter uni = new UniversalCharacter();
                    uni.setMinOccurs(this.getMinOccursFromAttributes(atts));
                    uni.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
                    this.stack.push(uni);
                } else if (localName.equals(BEGINOFLINE_ELEMENT)) {
                    BeginOfLine bol = new BeginOfLine();
                    this.stack.push(bol);
                } else if (localName.equals(ENDOFLINE_ELEMENT)) {
                    EndOfLine eol = new EndOfLine();
                    this.stack.push(eol);
                } else if (localName.equals(CHARACTERCLASS_ELEMENT)) {
                    CharacterClass characterclass = new CharacterClass();
                    characterclass.setExclusive(this.getExclusiveFromAttributes(atts));
                    characterclass.setMinOccurs(this.getMinOccursFromAttributes(atts));
                    characterclass.setMaxOccurs(this.getMaxOccursFromAttributes(atts));
                    this.stack.push(characterclass);
                } else if (localName.equals(CHARACTERSET_ELEMENT)) {
                    CharacterSet characterset = new CharacterSet();
                    characterset.setCharacters(atts.getValue("content"));
                    this.stack.push(characterset);
                } else if (localName.equals(CHARACTERINTERVAL_ELEMENT)) {
                    CharacterInterval characterinterval = new CharacterInterval();
                    characterinterval.setMinimum(atts.getValue(CHARACTERINTERVAL_MIN_ATTRIBUTE).charAt(0));
                    characterinterval.setMaximum(atts.getValue(CHARACTERINTERVAL_MAX_ATTRIBUTE).charAt(0));
                    this.stack.push(characterinterval);
                } else {
                    System.out.println("name=" + localName + " ns=" + namespaceURI + " qname=" + qName + " would not process");
                }
            } else {
                System.out.println("name=" + localName + " ns=" + namespaceURI + " qname=" + qName + " would not process");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

