/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.build;

import java.util.ArrayList;
import net.sourceforge.chaperon.build.EndOfFile;
import net.sourceforge.chaperon.build.FirstSetCollection;
import net.sourceforge.chaperon.build.ItemSet;
import net.sourceforge.chaperon.common.IntegerList;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.symbol.SymbolSet;
import org.apache.avalon.framework.logger.Logger;

public class ItemSetCollection {
    private static final EndOfFile EOF = new EndOfFile();
    private static final int NOTCHANGED = 0;
    private static final int CHANGED = 1;
    private ArrayList itemsets = new ArrayList();
    private Grammar grammar;
    private FirstSetCollection firstsets;
    private SymbolSet tsymbols;
    private SymbolSet ntsymbols;
    private Logger logger;

    public ItemSetCollection(Grammar grammar, FirstSetCollection firstsets) {
        this(grammar, firstsets, null);
    }

    public ItemSetCollection(Grammar grammar, FirstSetCollection firstsets, Logger logger) {
        boolean mustrepeat;
        int j;
        boolean changed;
        int index;
        ItemSet J;
        ItemSet I;
        this.grammar = grammar;
        this.firstsets = firstsets;
        this.logger = logger;
        SymbolSet symbols = grammar.getSymbols();
        this.tsymbols = symbols.getTerminals();
        this.ntsymbols = symbols.getNonterminals();
        IntegerList changedState = new IntegerList();
        this.addItemSet(this.getStartItemSet());
        changedState.add(1);
        int i = 0;
        while (i < this.getItemSetCount()) {
            boolean bl;
            changedState.set(i, 0);
            I = this.getItemSet(i);
            SymbolSet nextnonterminals = I.getNextNonterminals();
            int j2 = 0;
            while (j2 < nextnonterminals.getSymbolCount()) {
                J = I.jump(nextnonterminals.getSymbol(j2));
                if (!J.isEmpty()) {
                    index = this.indexOfCore(J);
                    if (index < 0) {
                        index = this.addItemSet(J);
                        changedState.add(1);
                    } else {
                        changed = this.getItemSet(index).addItemSet(J);
                        if (changed) {
                            if (index < changedState.getCount()) {
                                changedState.set(index, 1);
                            } else {
                                changedState.add(1);
                            }
                        }
                        if (index <= i && changed) {
                            bl = true;
                        }
                    }
                    I.setTransition(nextnonterminals.getSymbol(j2), index);
                }
                ++j2;
            }
            SymbolSet nextterminals = I.getNextTerminals();
            j = 0;
            while (j < nextterminals.getSymbolCount()) {
                J = I.jump(nextterminals.getSymbol(j));
                if (!J.isEmpty()) {
                    index = this.indexOfCore(J);
                    if (index < 0) {
                        index = this.addItemSet(J);
                        changedState.add(1);
                    } else {
                        changed = this.getItemSet(index).addItemSet(J);
                        if (changed) {
                            if (index < changedState.getCount()) {
                                changedState.set(index, 1);
                            } else {
                                changedState.add(1);
                            }
                        }
                        if (index <= i && changed) {
                            bl = true;
                        }
                    }
                    I.setTransition(nextterminals.getSymbol(j), index);
                }
                ++j;
            }
            ++i;
        }
        do {
            mustrepeat = false;
            int i2 = 0;
            while (i2 < this.getItemSetCount()) {
                if (changedState.get(i2) == 1) {
                    changedState.set(i2, 0);
                    I = this.getItemSet(i2);
                    symbols = I.getShiftSymbols();
                    j = 0;
                    while (j < symbols.getSymbolCount()) {
                        J = I.jump(symbols.getSymbol(j));
                        index = I.getTransition(symbols.getSymbol(j));
                        changed = this.getItemSet(index).addItemSet(J);
                        if (changed) {
                            if (index < changedState.getCount()) {
                                changedState.set(index, 1);
                            } else {
                                changedState.add(1);
                            }
                            if (index <= i2) {
                                mustrepeat = true;
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        } while (mustrepeat);
    }

    public int addItemSet(ItemSet itemset) {
        int index = this.indexOf(itemset);
        if (index == -1) {
            this.itemsets.add(itemset);
            index = this.itemsets.size() - 1;
        }
        return index;
    }

    public boolean contains(ItemSet itemset) {
        int i = 0;
        while (i < this.itemsets.size()) {
            if (((ItemSet)this.itemsets.get(i)).equals(itemset)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsCore(ItemSet itemset) {
        int i = 0;
        while (i < this.itemsets.size()) {
            if (((ItemSet)this.itemsets.get(i)).equalsCore(itemset)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ItemSet getItemSet(int index) {
        return (ItemSet)this.itemsets.get(index);
    }

    public int getItemSetCount() {
        return this.itemsets.size();
    }

    private ItemSet getStartItemSet() {
        ItemSet I = new ItemSet(this.grammar, this.firstsets);
        IntegerList startlist = this.grammar.getProductionList(this.grammar.getStartSymbol());
        int i = 0;
        while (i < startlist.getCount()) {
            I.addItem(startlist.get(i), 0, EOF);
            ++i;
        }
        return I.closure();
    }

    public int indexOf(ItemSet itemset) {
        int i = 0;
        while (i < this.itemsets.size()) {
            if (((ItemSet)this.itemsets.get(i)).equals(itemset)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOfCore(ItemSet itemset) {
        int i = 0;
        while (i < this.itemsets.size()) {
            if (((ItemSet)this.itemsets.get(i)).equalsCore(itemset)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.getItemSetCount()) {
            buffer.append("State ");
            buffer.append(String.valueOf(i));
            buffer.append(":\n");
            buffer.append(this.getItemSet(i).toString());
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }
}

