/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.process;

import net.sourceforge.chaperon.process.Locator;
import org.apache.avalon.framework.CascadingException;

public class ProcessingException
extends CascadingException {
    private boolean localized = false;
    private String URI = null;
    private int line = 0;
    private int column = 0;

    public ProcessingException(String message, Throwable t, Locator locator) {
        super(message, t);
        if (locator != null) {
            this.localized = true;
            this.URI = locator.getURI();
            this.line = locator.getLineNumber();
            this.column = locator.getColumnNumber();
        }
    }

    public ProcessingException(String message, Locator locator) {
        super(message, null);
        if (locator != null) {
            this.localized = true;
            this.URI = locator.getURI();
            this.line = locator.getLineNumber();
            this.column = locator.getColumnNumber();
        }
    }

    public int getColumnNumber() {
        return this.column;
    }

    public int getLineNumber() {
        return this.line;
    }

    public String getURI() {
        return this.URI;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.getCause() != null) {
            this.getCause().printStackTrace();
        }
    }

    public String toString() {
        Throwable t;
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        if (this.localized) {
            buffer.append(": ");
            buffer.append(this.URI);
            buffer.append(": ");
            buffer.append(this.line);
            buffer.append(": ");
            buffer.append(this.column);
        }
        if ((t = this.getCause()) != null) {
            buffer.append(": ");
            buffer.append(t.toString());
        }
        return buffer.toString();
    }
}

