/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Environment;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AvalonToCocoonSourceInvocationHandler
implements InvocationHandler {
    protected Source source;
    protected SourceResolver resolver;
    protected Environment environment;
    protected ComponentManager manager;
    static /* synthetic */ Class class$org$apache$cocoon$environment$Source;
    static /* synthetic */ Class class$org$apache$cocoon$environment$ModifiableSource;

    public AvalonToCocoonSourceInvocationHandler(Source source, SourceResolver resolver, Environment environment, ComponentManager manager) {
        this.source = source;
        this.resolver = resolver;
        this.environment = environment;
        this.manager = manager;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getName().equals("getInputStream")) {
                return this.getInputStream();
            }
            if (method.getName().equals("getInputSource")) {
                return this.getInputSource();
            }
            if (method.getName().equals("getSystemId")) {
                return this.getSystemId();
            }
            if (method.getName().equals("recycle")) {
                this.recycle();
                return null;
            }
            if (method.getName().equals("toSAX")) {
                this.toSAX((ContentHandler)args[0]);
                return null;
            }
            return method.invoke((Object)this.source, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public InputStream getInputStream() throws ProcessingException, IOException {
        try {
            return this.source.getInputStream();
        }
        catch (SourceException e) {
            throw SourceUtil.handle((SourceException)e);
        }
    }

    public InputSource getInputSource() throws ProcessingException, IOException {
        try {
            InputSource newObject = new InputSource(this.source.getInputStream());
            newObject.setSystemId(this.getSystemId());
            return newObject;
        }
        catch (SourceException se) {
            throw SourceUtil.handle((SourceException)se);
        }
    }

    public String getSystemId() {
        return this.source.getURI();
    }

    public void recycle() {
        this.resolver.release(this.source);
        this.source = null;
        this.environment = null;
    }

    public void refresh() {
        this.source.refresh();
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        try {
            SourceUtil.parse((ComponentManager)this.manager, (Source)this.source, (ContentHandler)handler);
        }
        catch (ProcessingException pe) {
            throw new SAXException("ProcessingException during streaming.", (Exception)((Object)pe));
        }
        catch (IOException ioe) {
            throw new SAXException("IOException during streaming.", ioe);
        }
    }

    public static org.apache.cocoon.environment.Source createProxy(Source source, SourceResolver resolver, Environment environment, ComponentManager manager) throws SourceException {
        Class<?>[] sourceInterfaces = source.getClass().getInterfaces();
        Class[] proxyInterfaces = new Class[sourceInterfaces.length + 2];
        int i = 0;
        while (i < sourceInterfaces.length) {
            proxyInterfaces[i] = sourceInterfaces[i];
            ++i;
        }
        proxyInterfaces[sourceInterfaces.length] = class$org$apache$cocoon$environment$Source == null ? (class$org$apache$cocoon$environment$Source = AvalonToCocoonSourceInvocationHandler.class$("org.apache.cocoon.environment.Source")) : class$org$apache$cocoon$environment$Source;
        proxyInterfaces[sourceInterfaces.length + 1] = class$org$apache$cocoon$environment$ModifiableSource == null ? (class$org$apache$cocoon$environment$ModifiableSource = AvalonToCocoonSourceInvocationHandler.class$("org.apache.cocoon.environment.ModifiableSource")) : class$org$apache$cocoon$environment$ModifiableSource;
        AvalonToCocoonSourceInvocationHandler invocationHandler = new AvalonToCocoonSourceInvocationHandler(source, resolver, environment, manager);
        try {
            org.apache.cocoon.environment.Source proxy = (org.apache.cocoon.environment.Source)Proxy.newProxyInstance(source.getClass().getClassLoader(), proxyInterfaces, (InvocationHandler)invocationHandler);
            return proxy;
        }
        catch (Exception e) {
            throw new SourceException("Error creating proxy object", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

