/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.flow.ContinuationsDisposer;
import org.apache.cocoon.components.flow.ContinuationsManager;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.excalibur.event.Queue;
import org.apache.excalibur.event.Sink;
import org.apache.excalibur.event.command.RepeatedCommand;

public class ContinuationsManagerImpl
extends AbstractLogEnabled
implements ContinuationsManager,
Component,
Configurable,
ThreadSafe,
Contextualizable {
    static final int CONTINUATION_ID_LENGTH = 20;
    static final String EXPIRE_CONTINUATIONS = "expire-continuations";
    protected SecureRandom random = null;
    protected byte[] bytes;
    protected Sink m_commandSink;
    protected int defaultTimeToLive;
    protected Set forrest = Collections.synchronizedSet(new HashSet());
    protected Map idToWebCont = Collections.synchronizedMap(new HashMap());
    protected SortedSet expirations = Collections.synchronizedSortedSet(new TreeSet());

    public ContinuationsManagerImpl() throws Exception {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException nsae) {
            this.random = SecureRandom.getInstance("IBMSecureRandom");
        }
        this.random.setSeed(System.currentTimeMillis());
        this.bytes = new byte[20];
    }

    public void configure(Configuration config) {
        block2: {
            this.defaultTimeToLive = config.getAttributeAsInteger("time-to-live", 3600000);
            Configuration expireConf = config.getChild("expirations-check");
            try {
                ContinuationInterrupt interrupt = new ContinuationInterrupt(expireConf);
                this.m_commandSink.enqueue((Object)interrupt);
            }
            catch (Exception ex) {
                if (!this.getLogger().isDebugEnabled()) break block2;
                this.getLogger().debug("WK: Exception while configuring WKManager " + ex);
            }
        }
    }

    public WebContinuation createWebContinuation(Object kont, WebContinuation parent, int timeToLive, ContinuationsDisposer disposer) {
        int ttl = timeToLive == 0 ? this.defaultTimeToLive : timeToLive;
        WebContinuation wk = this.generateContinuation(kont, parent, ttl, disposer);
        wk.enableLogging(this.getLogger());
        if (parent == null) {
            this.forrest.add(wk);
        }
        if (parent != null && wk.getParentContinuation().getChildren().size() < 2) {
            this.expirations.remove(wk.getParentContinuation());
        }
        this.expirations.add(wk);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("WK: Just Created New Continuation " + wk.getId());
        }
        return wk;
    }

    public void invalidateWebContinuation(WebContinuation wk) {
        WebContinuation parent = wk.getParentContinuation();
        if (parent == null) {
            this.forrest.remove(wk);
        } else {
            List parentKids = parent.getChildren();
            parentKids.remove(wk);
        }
        this._invalidate(wk);
    }

    private void _invalidate(WebContinuation wk) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("WK: Manual Expire of Continuation " + wk.getId());
        }
        this.disposeContinuation(wk);
        this.expirations.remove(wk);
        List children = wk.getChildren();
        int size = children.size();
        int i = 0;
        while (i < size) {
            this._invalidate((WebContinuation)children.get(i));
            ++i;
        }
    }

    private void disposeContinuation(WebContinuation wk) {
        this.idToWebCont.remove(wk.getId());
        ContinuationsDisposer disposer = wk.getDisposer();
        if (disposer != null) {
            disposer.disposeContinuation(wk);
        }
    }

    public WebContinuation lookupWebContinuation(String id) {
        return (WebContinuation)this.idToWebCont.get(id);
    }

    private WebContinuation generateContinuation(Object kont, WebContinuation parent, int ttl, ContinuationsDisposer disposer) {
        char[] result = new char[this.bytes.length * 2];
        WebContinuation wk = null;
        while (true) {
            this.random.nextBytes(this.bytes);
            int i = 0;
            while (i < 20) {
                byte ch = this.bytes[i];
                result[2 * i] = Character.forDigit(Math.abs(ch >> 4), 16);
                result[2 * i + 1] = Character.forDigit(Math.abs(ch & 0xF), 16);
                ++i;
            }
            String id = new String(result);
            Map map = this.idToWebCont;
            synchronized (map) {
                if (!this.idToWebCont.containsKey(id)) {
                    wk = new WebContinuation(id, kont, parent, ttl, disposer);
                    this.idToWebCont.put(id, wk);
                    break;
                }
            }
        }
        return wk;
    }

    private void removeContinuation(WebContinuation wk) {
        if (wk.getChildren().size() != 0) {
            return;
        }
        this.disposeContinuation(wk);
        WebContinuation parent = wk.getParentContinuation();
        if (parent == null) {
            this.forrest.remove(wk);
        } else {
            List parentKids = parent.getChildren();
            parentKids.remove(wk);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("WK: deleted this WK: " + wk.getId());
        }
        if (null != parent && parent.hasExpired()) {
            this.removeContinuation(parent);
        }
    }

    private void displayExpireSet() {
        Iterator iter = this.expirations.iterator();
        StringBuffer wkSet = new StringBuffer("\nWK; Expire Set Size: " + this.expirations.size());
        while (iter.hasNext()) {
            WebContinuation wk = (WebContinuation)iter.next();
            long lat = wk.getLastAccessTime() + wk.getTimeToLive();
            wkSet.append("\nWK: ").append(wk.getId()).append(" ExpireTime [");
            if (lat < System.currentTimeMillis()) {
                wkSet.append("Expired");
            } else {
                wkSet.append(lat);
            }
            wkSet.append("]");
        }
        this.getLogger().debug(wkSet.toString());
    }

    public void displayAllContinuations() {
        Iterator iter = this.forrest.iterator();
        while (iter.hasNext()) {
            ((WebContinuation)iter.next()).display();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void expireContinuations() {
        WebContinuation wk;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("WK: Forrest size: " + this.forrest.size());
            this.displayAllContinuations();
            this.displayExpireSet();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("WK CurrentSystemTime[" + System.currentTimeMillis() + "]: Cleaning up expired Continuations....");
        }
        Iterator iter = this.expirations.iterator();
        while (iter.hasNext() && (wk = (WebContinuation)iter.next()).hasExpired()) {
            void var1_2;
            iter.remove();
            this.removeContinuation((WebContinuation)var1_2);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("WK: Forrest size: " + this.forrest.size());
            this.displayAllContinuations();
            this.displayExpireSet();
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.m_commandSink = (Sink)context.get((Object)Queue.ROLE);
    }

    final class ContinuationInterrupt
    implements RepeatedCommand {
        private final long m_interval;
        private final long m_initialDelay;

        public ContinuationInterrupt(Configuration expireConf) {
            this.m_initialDelay = expireConf.getChild("offset", true).getValueAsLong(100L);
            this.m_interval = expireConf.getChild("period", true).getValueAsLong(100L);
        }

        public int getNumberOfRepeats() {
            return -1;
        }

        public long getRepeatInterval() {
            return this.m_interval;
        }

        public long getDelayInterval() {
            return this.m_initialDelay;
        }

        public void execute() throws Exception {
            ContinuationsManagerImpl.this.expireContinuations();
        }
    }
}

