/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.components.language.markup.xsp.XSPObjectHelper;
import org.apache.cocoon.components.language.markup.xsp.XSPUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XSPRequestHelper {
    private static final String URI = "http://apache.org/xsp/request/2.0";
    private static final String PREFIX = "xsp-request";

    private static void getLocale(Locale locale, ContentHandler handler) throws SAXException {
        XSPObjectHelper.start(URI, PREFIX, handler, "locale");
        XSPObjectHelper.elementData(URI, PREFIX, handler, "language", locale.getLanguage());
        XSPObjectHelper.elementData(URI, PREFIX, handler, "country", locale.getCountry());
        XSPObjectHelper.elementData(URI, PREFIX, handler, "variant", locale.getVariant());
        XSPObjectHelper.end(URI, PREFIX, handler, "locale");
    }

    public static void getLocale(Map objectModel, ContentHandler handler) throws SAXException {
        Request request = ObjectModelHelper.getRequest(objectModel);
        XSPRequestHelper.getLocale(request.getLocale(), handler);
    }

    public static Locale[] getLocales(Map objectModel) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        ArrayList a = new ArrayList(10);
        Enumeration e = request.getLocales();
        while (e.hasMoreElements()) {
            a.add(e.nextElement());
        }
        return a.toArray(new Locale[a.size()]);
    }

    public static void getLocales(Map objectModel, ContentHandler contentHandler) throws SAXException {
        Request request = ObjectModelHelper.getRequest(objectModel);
        XSPObjectHelper.start(URI, PREFIX, contentHandler, "locales");
        Enumeration e = request.getLocales();
        while (e.hasMoreElements()) {
            XSPRequestHelper.getLocale((Locale)e.nextElement(), contentHandler);
        }
        XSPObjectHelper.end(URI, PREFIX, contentHandler, "locales");
    }

    public static String getParameter(Map objectModel, String name, String defaultValue) {
        return XSPRequestHelper.getParameter(objectModel, name, defaultValue, null, null);
    }

    public static String getParameter(Map objectModel, String name, String defaultValue, String form_encoding, String container_encoding) {
        if (container_encoding == null) {
            container_encoding = "ISO-8859-1";
        }
        Request request = ObjectModelHelper.getRequest(objectModel);
        String value = request.getParameter(name);
        if (form_encoding != null && value != null && value.length() > 0) {
            try {
                value = new String(value.getBytes(container_encoding), form_encoding);
            }
            catch (UnsupportedEncodingException uee) {
                throw new CascadingRuntimeException("Unsupported Encoding Exception", (Throwable)uee);
            }
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static void getParameter(Map objectModel, ContentHandler contentHandler, String name, String defaultValue) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        XSPObjectHelper.addAttribute(attr, "name", name);
        XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "parameter", XSPRequestHelper.getParameter(objectModel, name, defaultValue, null, null), attr);
    }

    public static void getParameter(Map objectModel, ContentHandler contentHandler, String name, String defaultValue, String form_encoding, String container_encoding) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        XSPObjectHelper.addAttribute(attr, "name", name);
        XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "parameter", String.valueOf(XSPRequestHelper.getParameter(objectModel, name, defaultValue, form_encoding, container_encoding)), attr);
    }

    public static void getParameterValues(Map objectModel, ContentHandler contentHandler, String name) throws SAXException {
        Request request = ObjectModelHelper.getRequest(objectModel);
        AttributesImpl attr = new AttributesImpl();
        XSPObjectHelper.addAttribute(attr, "name", name);
        XSPObjectHelper.start(URI, PREFIX, contentHandler, "parameter-values", attr);
        String[] values = request.getParameterValues(name);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "value", values[i]);
                ++i;
            }
        }
        XSPObjectHelper.end(URI, PREFIX, contentHandler, "parameter-values");
    }

    public static void getParameterValues(Map objectModel, ContentHandler contentHandler, String name, String form_encoding, String container_encoding) throws SAXException {
        Request request = ObjectModelHelper.getRequest(objectModel);
        AttributesImpl attr = new AttributesImpl();
        XSPObjectHelper.addAttribute(attr, "name", name);
        XSPObjectHelper.start(URI, PREFIX, contentHandler, "parameter-values", attr);
        String[] values = request.getParameterValues(name);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                if (form_encoding != null && values[i] != null && values[i].length() > 0) {
                    try {
                        values[i] = new String(values[i].getBytes(container_encoding), form_encoding);
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new CascadingRuntimeException("Unsupported Encoding Exception", (Throwable)uee);
                    }
                }
                XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "value", values[i]);
                ++i;
            }
        }
        XSPObjectHelper.end(URI, PREFIX, contentHandler, "parameter-values");
    }

    public static String[] getParameterValues(Map objectModel, String name, String form_encoding, String container_encoding) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String[] values = request.getParameterValues(name);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                if (form_encoding != null && values[i] != null && values[i].length() > 0) {
                    try {
                        values[i] = new String(values[i].getBytes(container_encoding), form_encoding);
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new CascadingRuntimeException("Unsupported Encoding Exception", (Throwable)uee);
                    }
                }
                ++i;
            }
        }
        return values;
    }

    public static String[] getParameterNames(Map objectModel) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        ArrayList a = new ArrayList(10);
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            a.add(e.nextElement());
        }
        return a.toArray(new String[a.size()]);
    }

    public static void getParameterNames(Map objectModel, ContentHandler contentHandler) throws SAXException {
        Request request = ObjectModelHelper.getRequest(objectModel);
        XSPObjectHelper.start(URI, PREFIX, contentHandler, "parameter-names");
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "name", name);
        }
        XSPObjectHelper.end(URI, PREFIX, contentHandler, "parameter-names");
    }

    public static void getHeaderNames(Map objectModel, ContentHandler contentHandler) throws SAXException {
        Request request = ObjectModelHelper.getRequest(objectModel);
        XSPObjectHelper.start(URI, PREFIX, contentHandler, "header-names");
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "name", name);
        }
        XSPObjectHelper.end(URI, PREFIX, contentHandler, "header-names");
    }

    public static String[] getHeaderNames(Map objectModel) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        ArrayList a = new ArrayList(10);
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            a.add(e.nextElement());
        }
        return a.toArray(new String[a.size()]);
    }

    public static String[] getHeaders(Map objectModel, String name) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        ArrayList a = new ArrayList(10);
        Enumeration e = request.getHeaders(name);
        while (e.hasMoreElements()) {
            a.add(e.nextElement());
        }
        return a.toArray(new String[a.size()]);
    }

    public static void getHeaders(Map objectModel, String name, ContentHandler contentHandler) throws SAXException {
        Request request = ObjectModelHelper.getRequest(objectModel);
        AttributesImpl attr = new AttributesImpl();
        XSPObjectHelper.addAttribute(attr, "name", name);
        XSPObjectHelper.start(URI, PREFIX, contentHandler, "header-values");
        Enumeration e = request.getHeaders(name);
        while (e.hasMoreElements()) {
            String value = (String)e.nextElement();
            XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "value", value);
        }
        XSPObjectHelper.end(URI, PREFIX, contentHandler, "header-values");
    }

    public static Date getDateHeader(Map objectModel, String name) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        if (name == null || name.length() == 0) {
            return null;
        }
        long dateHeader = request.getDateHeader(name);
        if (dateHeader == -1L) {
            return null;
        }
        return new Date(dateHeader);
    }

    public static String getDateHeader(Map objectModel, String name, String format) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        if (name == null || name.length() == 0) {
            return null;
        }
        long dateHeader = request.getDateHeader(name);
        if (dateHeader == -1L) {
            return null;
        }
        if (format != null) {
            format = format.trim();
        }
        return XSPUtil.formatDate(new Date(dateHeader), format);
    }

    public static void getAttributeNames(Map objectModel, ContentHandler contentHandler) throws SAXException {
        Request request = ObjectModelHelper.getRequest(objectModel);
        XSPObjectHelper.start(URI, PREFIX, contentHandler, "attribute-names");
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "name", name);
        }
        XSPObjectHelper.end(URI, PREFIX, contentHandler, "attribute-names");
    }

    public static String[] getAttributeNames(Map objectModel) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        ArrayList a = new ArrayList(10);
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            a.add(e.nextElement());
        }
        return a.toArray(new String[a.size()]);
    }

    public static String getRequestedURL(Map objectModel) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        StringBuffer uribuf = null;
        boolean isSecure = request.isSecure();
        int port = request.getServerPort();
        uribuf = isSecure ? new StringBuffer("https://") : new StringBuffer("http://");
        uribuf.append(request.getServerName());
        if (isSecure) {
            if (port != 443) {
                uribuf.append(":").append(port);
            }
        } else if (port != 80) {
            uribuf.append(":").append(port);
        }
        uribuf.append(request.getRequestURI());
        return uribuf.toString();
    }

    public static Object getSessionAttribute(Map objectModel, String name, Object defaultValue) {
        Session session = ObjectModelHelper.getRequest(objectModel).getSession();
        Object obj = session.getAttribute(name);
        return obj != null ? obj : defaultValue;
    }

    public static void getSessionAttribute(Map objectModel, ContentHandler contentHandler, String name, Object defaultValue) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        XSPObjectHelper.addAttribute(attr, "name", name);
        XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "parameter", XSPRequestHelper.getSessionAttribute(objectModel, name, defaultValue).toString(), attr);
    }
}

