/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;

public class DateMetaInputModule
extends AbstractMetaModule
implements ThreadSafe {
    private String defaultFormat = "yyyy-MM-dd";
    private DateFormat defaultFormatter = null;

    public void configure(Configuration config) throws ConfigurationException {
        this.inputConf = config.getChild("input-module");
        this.defaultInput = this.inputConf.getAttribute("name", this.defaultInput);
        this.defaultFormat = this.inputConf.getAttribute("format", this.defaultFormat);
        if (this.defaultFormat != null) {
            this.defaultFormatter = new SimpleDateFormat(this.defaultFormat);
        }
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        if (this.defaultInput == null && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("No input module given");
        }
        Configuration mConf = null;
        String inputName = null;
        String parameter = name;
        String format = this.defaultFormat;
        DateFormat formatter = null;
        if (modeConf != null) {
            mConf = modeConf.getChild("input-module");
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            parameter = modeConf.getAttribute("parameter", parameter);
            format = modeConf.getAttribute("format", format);
            parameter = modeConf.getChild("parameter").getValue(parameter);
            format = modeConf.getChild("format").getValue(format);
        }
        formatter = this.defaultFormat.equals(format) ? this.defaultFormatter : new SimpleDateFormat(format);
        Object[] values = this.getValues(parameter, objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, mConf);
        Object[] dates = null;
        if (values != null) {
            dates = new Object[values.length];
            int i = 0;
            while (i < values.length) {
                block7: {
                    try {
                        dates[i] = formatter.parse(String.valueOf(values[i]));
                    }
                    catch (Exception e) {
                        if (!this.getLogger().isWarnEnabled()) break block7;
                        this.getLogger().warn("Problem: Aquired '" + values[i] + "' from '" + inputName + "' for '" + name + "' using format '" + format + "' : " + e.getMessage());
                    }
                }
                ++i;
            }
        }
        return dates;
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        if (this.defaultInput == null && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("No input module given");
        }
        Configuration inputConfig = this.inputConf;
        Configuration mConf = null;
        String inputName = null;
        if (modeConf != null) {
            mConf = modeConf.getChild("input-module");
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            if (inputName != null) {
                inputConfig = modeConf.getChild("input-module");
            }
        }
        Iterator iterator = this.getNames(objectModel, this.input, this.defaultInput, inputConfig, null, inputName, mConf);
        return iterator;
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object[] values = this.getAttributeValues(name, modeConf, objectModel);
        return values != null ? values[0] : null;
    }
}

