/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelinesNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.sitemap.PatternException;

public class CallFunctionNode
extends AbstractProcessingNode
implements Configurable,
Composable {
    protected String functionName;
    protected String continuationId;
    protected List parameters;
    protected VariableResolver functionNameResolver;
    protected VariableResolver continuationResolver;
    protected ComponentManager manager;
    protected Interpreter interpreter;

    public static List resolveList(List expressions, ComponentManager manager, InvokeContext context, Map objectModel) throws PatternException {
        int size;
        if (expressions == null || (size = expressions.size()) == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Interpreter.Argument> result = new ArrayList<Interpreter.Argument>(size);
        int i = 0;
        while (i < size) {
            Interpreter.Argument arg = (Interpreter.Argument)expressions.get(i);
            String value = VariableResolverFactory.getResolver(arg.value, manager).resolve(context, objectModel);
            result.add(new Interpreter.Argument(arg.name, value));
            ++i;
        }
        return result;
    }

    public CallFunctionNode(String funName, String contId) {
        this.functionName = funName;
        this.continuationId = contId;
    }

    public void setInterpreter(Interpreter interp) throws Exception {
        this.interpreter = interp;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.parameters = new ArrayList();
        Configuration[] params = config.getChildren("parameter");
        int i = 0;
        while (i < params.length) {
            Configuration param = params[i];
            String name = param.getAttribute("name", null);
            String value = param.getAttribute("value", null);
            this.parameters.add(new Interpreter.Argument(name, value));
            ++i;
        }
        try {
            if (this.functionName != null && VariableResolverFactory.needsResolve(this.functionName)) {
                this.functionNameResolver = VariableResolverFactory.getResolver(this.functionName, this.manager);
            }
            if (this.continuationId != null && VariableResolverFactory.needsResolve(this.continuationId)) {
                this.continuationResolver = VariableResolverFactory.getResolver(this.continuationId, this.manager);
            }
        }
        catch (PatternException ex) {
            throw new ConfigurationException(ex.toString());
        }
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public boolean invoke(Environment env, InvokeContext context) throws Exception {
        String continuation;
        Redirector redirector = PipelinesNode.getRedirector(env);
        List params = null;
        if (this.parameters != null) {
            params = CallFunctionNode.resolveList(this.parameters, this.manager, context, env.getObjectModel());
        }
        if ((continuation = this.continuationResolver != null ? this.continuationResolver.resolve(context, env.getObjectModel()) : this.continuationId) != null) {
            this.interpreter.handleContinuation(continuation, params, env);
            return redirector.hasRedirected();
        }
        String name = this.functionNameResolver != null ? this.functionNameResolver.resolve(context, env.getObjectModel()) : this.functionName;
        if (name != null) {
            this.interpreter.callFunction(name, params, env);
            return redirector.hasRedirected();
        }
        return false;
    }
}

