/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.selection.Selector;

public abstract class NamedPatternsSelector
extends AbstractLogEnabled
implements Configurable,
ThreadSafe,
Selector {
    private Map strings;

    protected void configure(Configuration conf, String confName, String nameAttr, String valueAttr) throws ConfigurationException {
        List<String> nameList;
        Configuration[] confs = conf.getChildren(confName);
        HashMap<String, ArrayList<String>> configMap = new HashMap<String, ArrayList<String>>();
        int i = 0;
        while (i < confs.length) {
            String name = confs[i].getAttribute(nameAttr);
            String value = confs[i].getAttribute(valueAttr);
            nameList = (List)configMap.get(name);
            if (nameList == null) {
                nameList = new ArrayList<String>();
                configMap.put(name, (ArrayList<String>)nameList);
            }
            nameList.add(value);
            ++i;
        }
        Iterator entries = configMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            nameList = (ArrayList<String>)entry.getValue();
            entry.setValue(nameList.toArray(new String[nameList.size()]));
        }
        this.strings = configMap;
    }

    protected boolean checkPatterns(String expression, String value) {
        if (value == null) {
            this.getLogger().debug("No value given -- failing.");
            return false;
        }
        String[] patterns = (String[])this.strings.get(expression);
        if (patterns == null) {
            this.getLogger().warn("No configuration for expression '" + expression + "' -- failing.");
            return false;
        }
        int i = 0;
        while (i < patterns.length) {
            if (value.indexOf(patterns[i]) != -1) {
                this.getLogger().debug(expression + " selected value " + value);
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract void configure(Configuration var1) throws ConfigurationException;

    public abstract boolean select(String var1, Map var2, Parameters var3);
}

