/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.transformation.MyFilter;
import org.apache.cocoon.transformation.helpers.IncludeCacheManager;
import org.apache.cocoon.transformation.helpers.IncludeCacheManagerSession;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CIncludeTransformer
extends AbstractSAXTransformer
implements Disposable,
CacheableProcessingComponent {
    public static final String CINCLUDE_NAMESPACE_URI = "http://apache.org/cocoon/include/1.0";
    public static final String CINCLUDE_INCLUDE_ELEMENT = "include";
    public static final String CINCLUDE_INCLUDE_ELEMENT_SRC_ATTRIBUTE = "src";
    public static final String CINCLUDE_INCLUDE_ELEMENT_ELEMENT_ATTRIBUTE = "element";
    public static final String CINCLUDE_INCLUDE_ELEMENT_SELECT_ATTRIBUTE = "select";
    public static final String CINCLUDE_INCLUDE_ELEMENT_NS_ATTRIBUTE = "ns";
    public static final String CINCLUDE_INCLUDE_ELEMENT_PREFIX_ATTRIBUTE = "prefix";
    public static final String CINCLUDE_INCLUDEXML_ELEMENT = "includexml";
    public static final String CINCLUDE_INCLUDEXML_ELEMENT_IGNORE_ERRORS_ATTRIBUTE = "ignoreErrors";
    public static final String CINCLUDE_SRC_ELEMENT = "src";
    public static final String CINCLUDE_CONFIGURATION_ELEMENT = "configuration";
    public static final String CINCLUDE_PARAMETERS_ELEMENT = "parameters";
    public static final String CINCLUDE_PARAMETER_ELEMENT = "parameter";
    public static final String CINCLUDE_NAME_ELEMENT = "name";
    public static final String CINCLUDE_VALUE_ELEMENT = "value";
    public static final String CINCLUDE_CACHED_INCLUDE_ELEMENT = "cached-include";
    protected static final String CINCLUDE_CACHED_INCLUDE_PLACEHOLDER_ELEMENT = "cached-includep";
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_INCLUDE = 1;
    protected Parameters configurationParameters;
    protected SourceParameters resourceParameters;
    protected int state;
    protected IncludeCacheManager cacheManager;
    protected IncludeCacheManagerSession cachingSession;
    protected boolean compiling;
    protected IncludeXMLConsumer filter;
    protected XMLSerializer recorder;
    protected AttributesImpl srcAttributes = new AttributesImpl();
    protected boolean supportCaching;
    protected long startTime;

    public CIncludeTransformer() {
        this.namespaceURI = CINCLUDE_NAMESPACE_URI;
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, source, parameters);
        this.state = 0;
        if (null != this.cacheManager) {
            this.cachingSession = this.cacheManager.getSession(this.parameters);
        }
        this.compiling = false;
        this.supportCaching = parameters.getParameterAsBoolean("support-caching", false);
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().debug("Starting CIncludeTransformer with session " + this.cachingSession);
            this.startTime = System.currentTimeMillis();
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        if (this.manager.hasComponent(IncludeCacheManager.ROLE)) {
            this.cacheManager = (IncludeCacheManager)this.manager.lookup(IncludeCacheManager.ROLE);
        } else {
            this.getLogger().warn("The cinclude transformer cannot find the IncludeCacheManager. Therefore caching is turned off for the include transformer.");
        }
    }

    public void dispose() {
        if (null != this.manager) {
            this.manager.release((Component)this.cacheManager);
            this.manager = null;
        }
    }

    public void recycle() {
        if (null != this.cachingSession) {
            this.cacheManager.terminateSession(this.cachingSession);
        }
        this.cachingSession = null;
        if (null != this.recorder) {
            this.manager.release((Component)this.recorder);
            this.recorder = null;
        }
        super.recycle();
        this.configurationParameters = null;
        this.resourceParameters = null;
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().debug("Finishing CachingCIncludeTransformer, time: " + (System.currentTimeMillis() - this.startTime));
            this.startTime = 0L;
        }
        this.filter = null;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        if (name.equals(CINCLUDE_INCLUDE_ELEMENT)) {
            this.processCIncludeElement(attr.getValue("", "src"), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_ELEMENT_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_SELECT_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_NS_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_PREFIX_ATTRIBUTE), false);
        } else if (name.equals(CINCLUDE_INCLUDEXML_ELEMENT) && this.state == 0) {
            this.state = 1;
            String ignoreErrors = attr.getValue("", CINCLUDE_INCLUDEXML_ELEMENT_IGNORE_ERRORS_ATTRIBUTE);
            if (ignoreErrors == null || ignoreErrors.length() == 0) {
                ignoreErrors = "false";
            }
            this.stack.push(new Boolean(this.ignoreEmptyCharacters));
            this.stack.push(new Boolean(this.ignoreWhitespaces));
            this.stack.push(ignoreErrors);
            this.ignoreEmptyCharacters = false;
            this.ignoreWhitespaces = true;
        } else if (name.equals("src") && this.state == 1) {
            this.startTextRecording();
        } else if (name.equals(CINCLUDE_CONFIGURATION_ELEMENT) && this.state == 1) {
            this.stack.push("end");
        } else if (name.equals(CINCLUDE_PARAMETERS_ELEMENT) && this.state == 1) {
            this.stack.push("end");
        } else if (!name.equals(CINCLUDE_PARAMETER_ELEMENT) || this.state != 1) {
            if (name.equals(CINCLUDE_NAME_ELEMENT) && this.state == 1) {
                this.startTextRecording();
            } else if (name.equals(CINCLUDE_VALUE_ELEMENT) && this.state == 1) {
                this.startSerializedXMLRecording(XMLUtils.defaultSerializeToXMLFormat(true));
            } else if (name.equals(CINCLUDE_CACHED_INCLUDE_ELEMENT)) {
                String src = this.processCIncludeElement(attr.getValue("", "src"), null, null, null, null, this.cacheManager != null);
                if (this.compiling) {
                    this.srcAttributes.addAttribute("", "src", "src", "CDATA", src);
                    super.startTransformingElement(uri, CINCLUDE_CACHED_INCLUDE_PLACEHOLDER_ELEMENT, raw + "p", this.srcAttributes);
                    this.srcAttributes.clear();
                }
            } else {
                super.startTransformingElement(uri, name, raw, attr);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTransformingElement(String uri, String name, String raw) throws ProcessingException, IOException, SAXException {
        if (name.equals(CINCLUDE_INCLUDE_ELEMENT)) {
            return;
        }
        if (name.equals(CINCLUDE_INCLUDEXML_ELEMENT) && this.state == 1) {
            block40: {
                this.state = 0;
                String resource = (String)this.stack.pop();
                boolean ignoreErrors = ((String)this.stack.pop()).equals("true");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Processing CIncludexml element: src=" + resource + ", ignoreErrors=" + ignoreErrors + ", configuration=" + this.configurationParameters + ", parameters=" + this.resourceParameters);
                }
                Source source = null;
                try {
                    try {
                        block38: {
                            source = SourceUtil.getSource(resource, this.configurationParameters, this.resourceParameters, this.resolver);
                            XMLSerializer serializer = null;
                            XMLDeserializer deserializer = null;
                            try {
                                try {
                                    if (ignoreErrors) {
                                        serializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
                                        deserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                                        SourceUtil.toSAX(source, serializer, this.configurationParameters, true);
                                        deserializer.setConsumer(this.xmlConsumer);
                                        deserializer.deserialize(serializer.getSAXFragment());
                                    } else {
                                        SourceUtil.toSAX(source, this.xmlConsumer, this.configurationParameters, true);
                                    }
                                }
                                catch (ProcessingException pe) {
                                    if (!ignoreErrors) {
                                        throw pe;
                                    }
                                    Object var12_18 = null;
                                    this.manager.release((Component)serializer);
                                    this.manager.release((Component)deserializer);
                                    break block38;
                                }
                                catch (ComponentException ignore) {
                                    Object var12_19 = null;
                                    this.manager.release((Component)serializer);
                                    this.manager.release(deserializer);
                                    break block38;
                                }
                                Object var12_17 = null;
                            }
                            catch (Throwable throwable) {
                                Object var12_20 = null;
                                this.manager.release((Component)serializer);
                                this.manager.release(deserializer);
                                throw throwable;
                            }
                            this.manager.release((Component)serializer);
                            this.manager.release((Component)deserializer);
                        }
                        Object var14_25 = null;
                    }
                    catch (SourceException se) {
                        if (!ignoreErrors) {
                            throw SourceUtil.handle(se);
                        }
                        Object var14_26 = null;
                        this.resolver.release(source);
                        break block40;
                    }
                    catch (SAXException se) {
                        if (!ignoreErrors) {
                            throw se;
                        }
                        Object var14_27 = null;
                        this.resolver.release(source);
                        break block40;
                    }
                    catch (IOException ioe) {
                        if (!ignoreErrors) {
                            throw ioe;
                        }
                        Object var14_28 = null;
                        this.resolver.release(source);
                        break block40;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_29 = null;
                    this.resolver.release(source);
                    throw throwable;
                }
                this.resolver.release(source);
            }
            this.ignoreWhitespaces = (Boolean)this.stack.pop();
            this.ignoreEmptyCharacters = (Boolean)this.stack.pop();
            return;
        }
        if (name.equals("src") && this.state == 1) {
            this.stack.push(this.endTextRecording());
            return;
        }
        if (name.equals(CINCLUDE_PARAMETERS_ELEMENT) && this.state == 1) {
            this.resourceParameters = new SourceParameters();
            String label = (String)this.stack.pop();
            String key = null;
            String value = null;
            while (true) {
                if (label.equals("end")) {
                    return;
                }
                if (label.equals(CINCLUDE_NAME_ELEMENT)) {
                    key = (String)this.stack.pop();
                }
                if (label.equals(CINCLUDE_VALUE_ELEMENT)) {
                    value = (String)this.stack.pop();
                }
                if (key != null && value != null) {
                    this.resourceParameters.setParameter(key, value);
                    key = null;
                    value = null;
                }
                label = (String)this.stack.pop();
            }
        }
        if (name.equals(CINCLUDE_CONFIGURATION_ELEMENT) && this.state == 1) {
            this.configurationParameters = new Parameters();
            String label = (String)this.stack.pop();
            String key = null;
            String value = null;
            while (true) {
                if (label.equals("end")) {
                    return;
                }
                if (label.equals(CINCLUDE_NAME_ELEMENT)) {
                    key = (String)this.stack.pop();
                }
                if (label.equals(CINCLUDE_VALUE_ELEMENT)) {
                    value = (String)this.stack.pop();
                }
                if (key != null && value != null) {
                    this.configurationParameters.setParameter(key, value);
                    key = null;
                    value = null;
                }
                label = (String)this.stack.pop();
            }
        }
        if (name.equals(CINCLUDE_PARAMETER_ELEMENT) && this.state == 1) {
            return;
        }
        if (name.equals(CINCLUDE_NAME_ELEMENT) && this.state == 1) {
            this.stack.push(this.endTextRecording());
            this.stack.push(CINCLUDE_NAME_ELEMENT);
            return;
        }
        if (name.equals(CINCLUDE_VALUE_ELEMENT) && this.state == 1) {
            this.stack.push(this.endSerializedXMLRecording());
            this.stack.push(CINCLUDE_VALUE_ELEMENT);
            return;
        }
        if (name.equals(CINCLUDE_CACHED_INCLUDE_ELEMENT)) {
            if (!this.compiling) return;
            super.endTransformingElement(uri, CINCLUDE_CACHED_INCLUDE_PLACEHOLDER_ELEMENT, raw + "p");
            return;
        }
        super.endTransformingElement(uri, name, raw);
    }

    protected String processCIncludeElement(String src, String element, String select, String ns, String prefix, boolean cache) throws SAXException, IOException {
        if (element == null) {
            element = "";
        }
        if (select == null) {
            select = "";
        }
        if (ns == null) {
            ns = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Processing CInclude element: src=" + src + ", element=" + element + ", select=" + select + ", ns=" + ns + ", prefix=" + prefix + ", caching=" + cache);
        }
        if (cache) {
            src = this.cacheManager.load(src, this.cachingSession);
            if (this.cachingSession.isParallel() && !this.cachingSession.isPreemptive()) {
                if (!this.compiling) {
                    this.compiling = true;
                    this.startCompiledXMLRecording();
                }
            } else {
                this.cacheManager.stream(src, this.cachingSession, this.filter);
            }
            return src;
        }
        if (!"".equals(element)) {
            AttributesImpl attrs = new AttributesImpl();
            if (!ns.equals("")) {
                super.startPrefixMapping(prefix, ns);
            }
            super.startElement(ns, element, !ns.equals("") && !prefix.equals("") ? prefix + ":" + element : element, attrs);
        }
        Source source = null;
        try {
            block26: {
                try {
                    source = this.resolver.resolveURI(src);
                    if (!"".equals(select)) {
                        DOMParser parser = null;
                        XPathProcessor processor = null;
                        try {
                            parser = (DOMParser)this.manager.lookup(DOMParser.ROLE);
                            processor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
                            InputSource input = SourceUtil.getInputSource(source);
                            Document document = parser.parseDocument(input);
                            NodeList list = processor.selectNodeList((Node)document, select);
                            int length = list.getLength();
                            int i = 0;
                            while (i < length) {
                                IncludeXMLConsumer.includeNode(list.item(i), this, this);
                                ++i;
                            }
                            Object var16_20 = null;
                        }
                        catch (Throwable throwable) {
                            Object var16_21 = null;
                            this.manager.release((Component)parser);
                            this.manager.release((Component)processor);
                            throw throwable;
                        }
                        this.manager.release((Component)parser);
                        this.manager.release((Component)processor);
                        {
                            break block26;
                        }
                    }
                    String mimeType = null;
                    if (null != this.configurationParameters) {
                        mimeType = this.configurationParameters.getParameter("mime-type", mimeType);
                    }
                    if (this.compiling) {
                        SourceUtil.toSAX(source, mimeType, new IncludeXMLConsumer(this.contentHandler, this.lexicalHandler));
                        break block26;
                    }
                    SourceUtil.toSAX(source, mimeType, this.filter);
                }
                catch (SourceException se) {
                    throw new SAXException("Exception in CIncludeTransformer", (Exception)((Object)se));
                }
                catch (IOException e) {
                    throw new SAXException("CIncludeTransformer could not read resource", e);
                }
                catch (ProcessingException e) {
                    throw new SAXException("Exception in CIncludeTransformer", (Exception)((Object)e));
                }
                catch (ComponentException e) {
                    throw new SAXException((Exception)((Object)e));
                }
            }
            Object var18_23 = null;
        }
        catch (Throwable throwable) {
            Object var18_24 = null;
            this.resolver.release(source);
            throw throwable;
        }
        this.resolver.release(source);
        if (!"".equals(element)) {
            super.endElement(ns, element, !ns.equals("") && !prefix.equals("") ? prefix + ":" + element : element);
            if (!ns.equals("")) {
                super.endPrefixMapping(prefix);
            }
        }
        return src;
    }

    protected void startCompiledXMLRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN startCompiledXMLRecording");
        }
        try {
            this.recorder = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
            this.addRecorder(this.recorder);
        }
        catch (ComponentException ce) {
            throw new SAXException("Unable to lookup xml serializer for compiling xml.", (Exception)((Object)ce));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END startCompiledXMLRecording");
        }
    }

    protected Object endCompiledXMLRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN endCompiledXMLRecording");
        }
        XMLSerializer recorder = (XMLSerializer)this.removeRecorder();
        byte[] text = (byte[])recorder.getSAXFragment();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END endCompiledXMLRecording text=" + text);
        }
        return text;
    }

    public void startDocument() throws SAXException {
        this.filter = new MyFilter(this.xmlConsumer, this);
        super.startDocument();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endDocument() throws SAXException {
        if (this.compiling) {
            Object compiledXML = this.endCompiledXMLRecording();
            XMLDeserializer deserializer = null;
            try {
                try {
                    deserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                    deserializer.setConsumer(this.filter);
                    deserializer.deserialize(compiledXML);
                }
                catch (ComponentException ce) {
                    throw new SAXException("Unable to lookup xml deserializer.", (Exception)((Object)ce));
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.manager.release((Component)deserializer);
                throw throwable;
            }
            this.manager.release((Component)deserializer);
        }
        super.endDocument();
    }

    public Serializable getKey() {
        if (this.supportCaching && null != this.cacheManager && this.cachingSession.getExpires() > 0L) {
            return "1";
        }
        return null;
    }

    public SourceValidity getValidity() {
        if (this.supportCaching && null != this.cacheManager && this.cachingSession.getExpires() > 0L && !this.cachingSession.isPurging()) {
            return this.cachingSession.getExpiresValidity();
        }
        return null;
    }
}

