/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.StringUtils;
import org.apache.excalibur.source.SourceParameters;

public class NetUtils {
    private static BitSet safeCharacters;
    private static final char[] hexadecimal;

    public static String decodePath(String path) {
        StringBuffer translatedPath = new StringBuffer(path.length());
        byte[] encodedchars = new byte[path.length() / 3];
        int i = 0;
        int length = path.length();
        int encodedcharsLength = 0;
        while (i < length) {
            if (path.charAt(i) == '%') {
                while (i < length && path.charAt(i) == '%') {
                    if (i + 2 < length) {
                        try {
                            byte x;
                            encodedchars[encodedcharsLength] = x = (byte)Integer.parseInt(path.substring(i + 1, i + 3), 16);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("NetUtils.decodePath: illegal hex characters in pattern %" + path.substring(i + 1, i + 3));
                        }
                        ++encodedcharsLength;
                        i += 3;
                        continue;
                    }
                    throw new IllegalArgumentException("NetUtils.decodePath: % character should be followed by 2 hexadecimal characters.");
                }
                try {
                    String translatedPart = new String(encodedchars, 0, encodedcharsLength, "UTF-8");
                    translatedPath.append(translatedPart);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Problem in decodePath: UTF-8 encoding not supported.");
                }
                encodedcharsLength = 0;
                continue;
            }
            translatedPath.append(path.charAt(i));
            ++i;
        }
        return translatedPath.toString();
    }

    public static String encodePath(String path) {
        int maxBytesPerChar = 10;
        StringBuffer rewrittenPath = new StringBuffer(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, "UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        int i = 0;
        while (i < path.length()) {
            block8: {
                char c = path.charAt(i);
                if (safeCharacters.get(c)) {
                    rewrittenPath.append(c);
                } else {
                    try {
                        writer.write(c);
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block8;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        byte toEncode = ba[j];
                        rewrittenPath.append('%');
                        int low = toEncode & 0xF;
                        int high = (toEncode & 0xF0) >> 4;
                        rewrittenPath.append(hexadecimal[high]);
                        rewrittenPath.append(hexadecimal[low]);
                        ++j;
                    }
                    buf.reset();
                }
            }
            ++i;
        }
        return rewrittenPath.toString();
    }

    public static String getPath(String uri) {
        int i = uri.lastIndexOf(47);
        if (i > -1) {
            return uri.substring(0, i);
        }
        i = uri.indexOf(58);
        return i > -1 ? uri.substring(i + 1, uri.length()) : "";
    }

    public static String getExtension(String uri) {
        int dot = uri.lastIndexOf(46);
        if (dot > -1) {
            int slash = (uri = uri.substring(dot)).lastIndexOf(47);
            if (slash > -1) {
                return null;
            }
            int sharp = uri.lastIndexOf(35);
            if (sharp > -1) {
                return uri.substring(0, sharp);
            }
            int mark = uri.lastIndexOf(63);
            if (mark > -1) {
                return uri.substring(0, mark);
            }
            return uri;
        }
        return null;
    }

    public static String absolutize(String path, String relativeResource) {
        if ("".equals(path) || path == null) {
            return relativeResource;
        }
        if (relativeResource.charAt(0) != '/') {
            int length = path.length() - 1;
            boolean slashPresent = path.charAt(length) == '/';
            StringBuffer b = new StringBuffer();
            b.append(path);
            if (!slashPresent) {
                b.append('/');
            }
            b.append(relativeResource);
            return b.toString();
        }
        return relativeResource;
    }

    public static String relativize(String path, String absoluteResource) {
        if ("".equals(path) || path == null) {
            return absoluteResource;
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        if (absoluteResource.startsWith(path)) {
            return absoluteResource.substring(path.length());
        }
        int index = StringUtils.matchStrings(path, absoluteResource);
        if (index > 0 && path.charAt(index - 1) != '/') {
            index = path.substring(0, index).lastIndexOf(47);
            ++index;
        }
        String pathDiff = path.substring(index);
        String resource = absoluteResource.substring(index);
        int levels = StringUtils.count(pathDiff, '/');
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < levels) {
            b.append("../");
            ++i;
        }
        b.append(resource);
        return b.toString();
    }

    public static String normalize(String uri) {
        String[] dirty = StringUtils.split(uri, "/");
        int length = dirty.length;
        String[] clean = new String[length];
        while (true) {
            boolean path = false;
            boolean finished = true;
            int i = 0;
            int j = 0;
            while (i < length && dirty[i] != null) {
                if (!".".equals(dirty[i])) {
                    if ("..".equals(dirty[i])) {
                        clean[j++] = dirty[i];
                        if (path) {
                            finished = false;
                        }
                    } else if (i + 1 < length && "..".equals(dirty[i + 1])) {
                        ++i;
                    } else {
                        clean[j++] = dirty[i];
                        path = true;
                    }
                }
                ++i;
            }
            if (finished) break;
            dirty = clean;
            clean = new String[length];
        }
        StringBuffer b = new StringBuffer(uri.length());
        int i = 0;
        while (i < length && clean[i] != null) {
            b.append(clean[i]);
            if (i + 1 < length && clean[i + 1] != null) {
                b.append("/");
            }
            ++i;
        }
        return b.toString();
    }

    public static String deparameterize(String uri, Map parameters) {
        int i = uri.lastIndexOf(63);
        if (i == -1) {
            return uri;
        }
        String[] params = StringUtils.split(uri.substring(i + 1), "&");
        int j = 0;
        while (j < params.length) {
            String p = params[j];
            int k = p.indexOf(61);
            if (k == -1) break;
            String name = p.substring(0, k);
            String value = p.substring(k + 1);
            parameters.put(name, value);
            ++j;
        }
        return uri.substring(0, i);
    }

    public static String parameterize(String uri, Map parameters) {
        if (parameters.size() == 0) {
            return uri;
        }
        StringBuffer buffer = new StringBuffer(uri);
        buffer.append('?');
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            buffer.append(entry.getKey());
            buffer.append('=');
            buffer.append(entry.getValue());
            if (!i.hasNext()) continue;
            buffer.append('&');
        }
        return buffer.toString();
    }

    public static SourceParameters createParameters(Request request) {
        SourceParameters pars = new SourceParameters();
        if (null != request) {
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String current = (String)names.nextElement();
                String[] values = request.getParameterValues(current);
                if (null == values) continue;
                int i = 0;
                while (i < values.length) {
                    pars.setParameter(current, values[i]);
                    ++i;
                }
            }
        }
        return pars;
    }

    public static String removeAuthorisation(String uri) {
        if (uri.indexOf("@") != -1 && (uri.startsWith("ftp://") || uri.startsWith("http://"))) {
            return uri.substring(0, uri.indexOf(":") + 2) + uri.substring(uri.indexOf("@") + 1);
        }
        return uri;
    }

    static {
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        safeCharacters = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            safeCharacters.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            safeCharacters.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            safeCharacters.set(i);
            ++i;
        }
        safeCharacters.set(36);
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(43);
        safeCharacters.set(33);
        safeCharacters.set(42);
        safeCharacters.set(39);
        safeCharacters.set(40);
        safeCharacters.set(41);
        safeCharacters.set(44);
        safeCharacters.set(47);
        safeCharacters.set(58);
        safeCharacters.set(64);
        safeCharacters.set(38);
        safeCharacters.set(61);
    }
}

