/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitLoggerManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.WrapperServiceManager;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.log.Priority;

public class ExcaliburComponentManagerCreator
implements Disposable {
    private org.apache.avalon.framework.logger.Logger m_logger;
    private final org.apache.avalon.framework.logger.Logger m_primordialLogger;
    private Context m_context;
    private LoggerManager m_loggerManager;
    private RoleManager m_roleManager;
    private ComponentManager m_componentManager;
    private ServiceManager m_serviceManager;
    private InstrumentManager m_instrumentManager;

    private static Context createDefaultContext() {
        DefaultContext context = new DefaultContext();
        context.makeReadOnly();
        return context;
    }

    private static Configuration readConfigurationFromStream(InputStream is) throws Exception {
        if (is == null) {
            return null;
        }
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration config = builder.build(is);
        return config;
    }

    private static Configuration readConfigurationFromFile(File file) throws Exception {
        Configuration configuration;
        if (file == null) {
            return null;
        }
        FileInputStream is = new FileInputStream(file);
        try {
            configuration = ExcaliburComponentManagerCreator.readConfigurationFromStream(is);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InputStream)is).close();
            throw throwable;
        }
        ((InputStream)is).close();
        return configuration;
    }

    public ExcaliburComponentManagerCreator(Context context, Configuration loggerManagerConfig, Configuration roleManagerConfig, Configuration componentManagerConfig, Configuration instrumentManagerConfig) throws Exception {
        this.m_context = context == null ? ExcaliburComponentManagerCreator.createDefaultContext() : context;
        this.m_primordialLogger = new ConsoleLogger(1);
        try {
            this.initializeLoggerManager(loggerManagerConfig);
            this.initializeRoleManager(roleManagerConfig);
            this.initializeInstrumentManager(instrumentManagerConfig);
            this.initializeComponentManager(componentManagerConfig);
        }
        catch (Exception e) {
            this.dispose();
            throw e;
        }
    }

    public ExcaliburComponentManagerCreator(Context context, InputStream loggerManagerConfigStream, InputStream roleManagerConfigStream, InputStream componentManagerConfigStream, InputStream instrumentManagerConfigStream) throws Exception {
        this(context, ExcaliburComponentManagerCreator.readConfigurationFromStream(loggerManagerConfigStream), ExcaliburComponentManagerCreator.readConfigurationFromStream(roleManagerConfigStream), ExcaliburComponentManagerCreator.readConfigurationFromStream(componentManagerConfigStream), ExcaliburComponentManagerCreator.readConfigurationFromStream(instrumentManagerConfigStream));
    }

    public ExcaliburComponentManagerCreator(Context context, File loggerManagerConfigFile, File roleManagerConfigFile, File componentManagerConfigFile, File instrumentManagerConfigFile) throws Exception {
        this(context, ExcaliburComponentManagerCreator.readConfigurationFromFile(loggerManagerConfigFile), ExcaliburComponentManagerCreator.readConfigurationFromFile(roleManagerConfigFile), ExcaliburComponentManagerCreator.readConfigurationFromFile(componentManagerConfigFile), ExcaliburComponentManagerCreator.readConfigurationFromFile(instrumentManagerConfigFile));
    }

    public void dispose() {
        try {
            if (this.m_componentManager != null) {
                ContainerUtil.shutdown((Object)this.m_componentManager);
            }
            if (this.m_instrumentManager != null) {
                ContainerUtil.shutdown((Object)this.m_instrumentManager);
            }
            if (this.m_roleManager != null) {
                ContainerUtil.shutdown((Object)this.m_roleManager);
            }
            if (this.m_loggerManager != null) {
                ContainerUtil.shutdown((Object)this.m_loggerManager);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Unexpected error disposing managers.", (Throwable)e);
        }
    }

    public LoggerManager getLoggerManager() {
        return this.m_loggerManager;
    }

    public InstrumentManager getInstrumentManager() {
        return this.m_instrumentManager;
    }

    public ComponentManager getComponentManager() {
        return this.m_componentManager;
    }

    public ServiceManager getServiceManager() {
        return this.m_serviceManager;
    }

    private org.apache.avalon.framework.logger.Logger getLogger() {
        if (this.m_logger != null) {
            return this.m_logger;
        }
        return this.m_primordialLogger;
    }

    private void initializeLoggerManager(Configuration loggerManagerConfig) throws Exception {
        String lmLoggerName;
        String lmDefaultLoggerName;
        String logPrefix = null;
        if (logPrefix == null) {
            lmDefaultLoggerName = "";
            lmLoggerName = loggerManagerConfig.getAttribute("logger", "system.logkit");
        } else {
            lmDefaultLoggerName = logPrefix;
            lmLoggerName = logPrefix + '.' + loggerManagerConfig.getAttribute("logger", "system.logkit");
        }
        Logger lmDefaultLogger = Hierarchy.getDefaultHierarchy().getLoggerFor(lmDefaultLoggerName);
        lmDefaultLogger.setPriority(Priority.DEBUG);
        Logger lmLogger = Hierarchy.getDefaultHierarchy().getLoggerFor(lmLoggerName);
        lmLogger.setPriority(Priority.getPriorityForName((String)loggerManagerConfig.getAttribute("log-level", "DEBUG")));
        LogKitLoggerManager loggerManager = new LogKitLoggerManager(logPrefix, Hierarchy.getDefaultHierarchy(), (org.apache.avalon.framework.logger.Logger)new LogKitLogger(lmDefaultLogger), (org.apache.avalon.framework.logger.Logger)new LogKitLogger(lmLogger));
        loggerManager.contextualize(this.m_context);
        loggerManager.configure(loggerManagerConfig);
        this.m_loggerManager = loggerManager;
        if (this.m_logger == null) {
            this.getLogger().debug("Switching to default Logger provided by LoggerManager.");
            this.m_logger = this.m_loggerManager.getDefaultLogger();
        }
    }

    private void initializeRoleManager(Configuration roleManagerConfig) throws Exception {
        org.apache.avalon.framework.logger.Logger rmLogger = this.m_loggerManager.getLoggerForCategory(roleManagerConfig.getAttribute("logger", "system.roles"));
        DefaultRoleManager roleManager = new DefaultRoleManager();
        roleManager.enableLogging(rmLogger);
        roleManager.configure(roleManagerConfig);
        this.m_roleManager = roleManager;
    }

    private void initializeInstrumentManager(Configuration instrumentManagerConfig) throws Exception {
        if (instrumentManagerConfig != null) {
            org.apache.avalon.framework.logger.Logger imLogger = this.m_loggerManager.getLoggerForCategory(instrumentManagerConfig.getAttribute("logger", "system.instrument"));
            DefaultInstrumentManager instrumentManager = new DefaultInstrumentManager();
            instrumentManager.enableLogging(imLogger);
            instrumentManager.configure(instrumentManagerConfig);
            instrumentManager.initialize();
            this.m_instrumentManager = instrumentManager;
        }
    }

    private void initializeComponentManager(Configuration componentManagerConfig) throws Exception {
        org.apache.avalon.framework.logger.Logger cmLogger = this.m_loggerManager.getLoggerForCategory(componentManagerConfig.getAttribute("logger", "system.components"));
        ExcaliburComponentManager componentManager = new ExcaliburComponentManager();
        componentManager.enableLogging(cmLogger);
        componentManager.setLoggerManager(this.m_loggerManager);
        componentManager.contextualize(this.m_context);
        if (this.m_instrumentManager != null) {
            componentManager.setInstrumentManager(this.m_instrumentManager);
        }
        componentManager.setRoleManager(this.m_roleManager);
        componentManager.configure(componentManagerConfig);
        componentManager.initialize();
        this.m_componentManager = componentManager;
        this.m_serviceManager = new WrapperServiceManager(this.m_componentManager);
    }
}

