package freeguide.build.patchallfiles;

import freeguide.plugins.program.freeguide.lib.fgspecific.PluginInfo;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

/**
 * DOCUMENT ME!
 *
 * @author $author$
 * @version $Revision: 1362 $
 */
public class PatchBuild
{
    static void patch( final PluginInfo[] plugins ) throws Exception
    {
        final BufferedWriter out =
            new BufferedWriter( 
                new OutputStreamWriter( 
                    new FileOutputStream( "ant/plugins-info.xml" ), "UTF-8" ) );

        writeHeader( out, plugins );
        listPlugins( out, plugins );
        writeFooter( out );
        out.flush(  );

        out.close(  );
    }

    protected static void listPlugins( 
        final BufferedWriter out, PluginInfo[] plugins )
        throws Exception
    {
        for( int i = 0; i < plugins.length; i++ )
        {
            out.write( "    <antcall target=\"${actual-target}\">\n" );
            out.write( 
                "      <param name=\"plugin-id\" value=\""
                + plugins[i].getID(  ) + "\"/>\n" );
            out.write( 
                "      <param name=\"plugin-dir\" value=\""
                + plugins[i].getID(  ).replace( '-', '/' ) + "\"/>\n" );
            out.write( 
                "      <param name=\"plugin-version\" value=\""
                + plugins[i].getVersion(  ).getDotFormat(  ) + "\"/>\n" );
            out.write( "    </antcall>\n" );
        }
    }

    protected static void writeHeader( 
        final BufferedWriter out, final PluginInfo[] plugins )
        throws IOException
    {
        out.write( "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n" );

        out.write( 
            "<!-- This file is autogenerated from the available plugins. Don't change it, as changes will be over-written. -->\n\n" );

        out.write( 
            "<project name=\"freeguide-tv-plugins-info\" basedir=\".\">\n" );
        out.write( 
            "  <property name=\"application-id\" value=\"freeguide\"/>\n" );
        out.write( 
            "  <property name=\"application-version\" value=\""
            + plugins[0].getVersion(  ).getDotFormat(  ) + "\"/>\n" );
        out.write( 
            "  <target name=\"all-plugins\" description=\"Do something for each plugin\">\n" );
    }

    protected static void writeFooter( final BufferedWriter out )
        throws IOException
    {
        out.write( "  </target>\n" );
        out.write( "</project>\n" );
    }
}
