/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver;

import java.util.Date;
import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.util.attrs.ASMifiable;
import org.objectweb.asm.util.attrs.Traceable;

public class RetroWeaverAttribute
extends Attribute
implements ASMifiable,
Traceable {
    private static final String RETROWEAVER_ATTRIBUTE_NAME = "net.sourceforge.Retroweaver";
    private final int retroweaverBuildNumber;
    private final int originalClassVersion;
    private final long timestamp;

    public RetroWeaverAttribute(int retroweaverBuildNumber, int originalClassVersion) {
        this(retroweaverBuildNumber, originalClassVersion, System.currentTimeMillis());
    }

    public RetroWeaverAttribute(int retroweaverBuildNumber, int originalClassVersion, long timestamp) {
        super(RETROWEAVER_ATTRIBUTE_NAME);
        this.retroweaverBuildNumber = retroweaverBuildNumber;
        this.originalClassVersion = originalClassVersion;
        this.timestamp = timestamp;
    }

    public int getRetroweaverBuildNumber() {
        return this.retroweaverBuildNumber;
    }

    public int getOriginalClassVersion() {
        return this.originalClassVersion;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isUnknown() {
        return false;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        return new RetroWeaverAttribute(cr.readInt(off), cr.readInt(off + 4), cr.readLong(off + 8));
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector bv = new ByteVector();
        bv.putInt(this.retroweaverBuildNumber);
        bv.putInt(this.originalClassVersion);
        bv.putLong(this.timestamp);
        return bv;
    }

    public void asmify(StringBuffer buf, String varName, Map labelNames) {
        buf.append("Attribute ").append(varName).append(" = new com.rc.retroweaver.RetroweaverAttribute(").append(this.retroweaverBuildNumber).append(", ").append(this.originalClassVersion).append(", ").append(this.timestamp).append(" /*").append(new Date(this.timestamp)).append("*/").append(");\n");
    }

    public void trace(StringBuffer buf, Map labelNames) {
        buf.append(this.retroweaverBuildNumber).append(' ').append(this.originalClassVersion).append(' ').append(this.timestamp).append(" (").append(new Date(this.timestamp)).append(")\n");
    }
}

