# A few GUI routines for asking the user questions using gdialog

package XMLTV::Ask::GDialog;
use strict;

# Use Log::TraceMessages if installed.
BEGIN {
    eval { require Log::TraceMessages };
    if ($@) {
	*t = sub {};
	*d = sub { '' };
    }
    else {
	*t = \&Log::TraceMessages::t;
	*d = \&Log::TraceMessages::d;
    }
}

# Ask a question with a free text answer.
# Parameters:
#   current module name
#   question text
# Returns the text entered by the user.
sub ask( $$ ) {
        
        shift;
        my $question = shift;

        my $answer = `gdialog --title 'Question' --inputbox '$question' 10 20`;
        
        if($?) {
                if($?==256) {
                        die("Cancel pressed");
                } else {
                        die("Error running gdialog: $?");
                }
        }
        
        return $answer;
        
}


# Ask a question where the answer is one of a set of alternatives.
#
# Parameters:
#   current module name
#   question text
#   default choice
#   Remaining arguments are the choices available.
#
# Returns one of the choices, or undef if input could not be read.
#
sub ask_choice( $$$@ ) {
        shift;
        my $question = shift; die if not defined $question;
        my $default = shift; die if not defined $default;
        my @options = @_; die if not @options;
        
        my @double_options;
        
        foreach (@options) {
                
                push @double_options, $_;
                push @double_options, "\"\"";
                push @double_options, (($default eq $_) ? "on" : "off");
                
        }
        
        my $answer = `gdialog --title 'Question' --radiolist '$question' 10 20 20 @double_options 2>&1`;
        
        if($?) {
                if($?==256) {
                        die("Cancel pressed");
                } else {
                        die("Error running gdialog: $?");
                }
        }
        
        # Return undef if the answer is blank.
        return $answer || undef;
        
}

# Ask a yes/no question.
#
# Parameters:
#   current module name
#   question text
#   default (true or false)
#
# Returns true or false, or undef if input could not be read.
#
sub ask_boolean( $$$ ) {
        shift;
        my ($question, $default) = @_;
        
	my $answer = system("gdialog", "--title", "Question", "--yesno", "$question", "10", "20");
        
        if($answer!=0 && $answer!=256) {
                die("Error running gdialog: $?");
        }
        
        return !$answer;
        
}

# Ask yes/no questions with option 'default to all'.
#
# Parameters:
#   current module name
#   default (true or false),
#   question texts (one per question).
#
# Returns: lots of booleans, one for each question.  If input cannot
# be read, then a partial list is returned.
#
sub ask_many_boolean( $$@ ) {
        shift;
        my $default=shift;
        my @options = @_;
        
        $default = (($default eq "yes") ? "on" : "off");
        
        my @double_options;
        
        foreach (@options) {
                
                push @double_options, $_;
                push @double_options, "\"\"";
                push @double_options, $default;
                
        }
        
        my @answer = `gdialog --title 'Question' --checklist '' 10 20 20 @double_options 2>&1`;
        
        if($?) {
                if($?==256) {
                        die("Cancel pressed");
                } else {
                        die("Error running gdialog: $?");
                }
        }
        
        return @answer;
        
}

# Give some information to the user
# Parameters:
#   current module name
#   text to show to the user
sub say( $$ ) {
        shift;
        my $question = shift;
	
        system("gdialog", "--title", "Question", "--msgbox", "$question", "10", "20");
        
}


1;
