/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import com.sun.appserv.server.util.ClassLoaderChain;
import com.sun.enterprise.server.PELaunch;
import java.net.URL;
import java.net.URLClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASURLClassLoader
extends URLClassLoader {
    private URL[] classLoaderList = new URL[0];
    private String nameOfCL = null;
    private ClassLoader parentChain = null;
    private String parentToString = null;

    public ASURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, PELaunch.getSharedChain() != null ? PELaunch.getSharedChain() : ClassLoader.getSystemClassLoader());
        this.parentChain = parent;
        this.parentToString = this.parentChain instanceof ClassLoaderChain ? ((ClassLoaderChain)this.parentChain).getName() : this.parentChain.toString();
        this.classLoaderList = urls;
    }

    public void setName(String n) {
        this.nameOfCL = n;
    }

    @Override
    public String getName() {
        return this.nameOfCL;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> cls = super.loadClass(name, resolve);
            if (cls != null) {
                return cls;
            }
            throw new ClassNotFoundException(name);
        }
        catch (ClassNotFoundException e) {
            ClassLoaderChain chain;
            Class c;
            if (this.parentChain != null && this.parentChain instanceof ClassLoaderChain && (c = (chain = (ClassLoaderChain)this.parentChain).loadClass(name, this)) != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            throw e;
        }
    }

    public String toString() {
        String s = this.nameOfCL + " parentCL :: " + this.parentToString + " URLs :: \n";
        for (URL u : this.classLoaderList) {
            s = s + ", " + u;
        }
        s = s + "\n";
        return s;
    }
}

